/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.BooleanParameterValue;
import hudson.model.Messages;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.SimpleParameterDefinition;
import java.util.Objects;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest2;

public class BooleanParameterDefinition
extends SimpleParameterDefinition {
    private boolean defaultValue;

    @DataBoundConstructor
    public BooleanParameterDefinition(@NonNull String name) {
        super(name);
    }

    public BooleanParameterDefinition(@NonNull String name, boolean defaultValue, @CheckForNull String description) {
        this(name);
        this.setDefaultValue(defaultValue);
        this.setDescription(description);
    }

    @Override
    public ParameterDefinition copyWithDefaultValue(ParameterValue defaultValue) {
        if (defaultValue instanceof BooleanParameterValue) {
            BooleanParameterValue value = (BooleanParameterValue)defaultValue;
            return new BooleanParameterDefinition(this.getName(), value.value, this.getDescription());
        }
        return this;
    }

    public boolean isDefaultValue() {
        return this.defaultValue;
    }

    @DataBoundSetter
    public void setDefaultValue(boolean defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public ParameterValue createValue(StaplerRequest2 req, JSONObject jo) {
        BooleanParameterValue value = (BooleanParameterValue)req.bindJSON(BooleanParameterValue.class, jo);
        value.setDescription(this.getDescription());
        return value;
    }

    @Override
    public ParameterValue createValue(String value) {
        return new BooleanParameterValue(this.getName(), Boolean.parseBoolean(value), this.getDescription());
    }

    @Override
    public BooleanParameterValue getDefaultParameterValue() {
        return new BooleanParameterValue(this.getName(), this.defaultValue, this.getDescription());
    }

    @Override
    public int hashCode() {
        if (BooleanParameterDefinition.class != this.getClass()) {
            return super.hashCode();
        }
        return Objects.hash(this.getName(), this.getDescription(), this.defaultValue);
    }

    @Override
    @SuppressFBWarnings(value={"EQ_GETCLASS_AND_CLASS_CONSTANT"}, justification="ParameterDefinitionTest tests that subclasses are not equal to their parent classes, so the behavior appears to be intentional")
    public boolean equals(Object obj) {
        if (BooleanParameterDefinition.class != this.getClass()) {
            return super.equals(obj);
        }
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BooleanParameterDefinition other = (BooleanParameterDefinition)obj;
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(this.getDescription(), other.getDescription())) {
            return false;
        }
        return this.defaultValue == other.defaultValue;
    }

    @Extension
    @Symbol(value={"booleanParam"})
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.BooleanParameterDefinition_DisplayName();
        }

        @Override
        public String getHelpFile() {
            return "/help/parameter/boolean.html";
        }
    }
}

