/*
 * Decompiled with CFR 0.152.
 */
package hudson.console;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.MarkupText;
import hudson.Util;
import hudson.console.ConsoleAnnotationDescriptor;
import hudson.console.ConsoleAnnotator;
import hudson.console.ConsoleNote;
import hudson.console.HyperlinkNote;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExpandableDetailsNote
extends ConsoleNote {
    private final String caption;
    private final String html;
    private static final Logger LOGGER = Logger.getLogger(ExpandableDetailsNote.class.getName());

    public ExpandableDetailsNote(String caption, String html) {
        this.caption = caption;
        this.html = html;
    }

    public ConsoleAnnotator annotate(Object context, MarkupText text, int charPos) {
        text.addMarkup(charPos, "<button type='button' class='jenkins-button reveal-expandable-detail'>" + Util.xmlEscape(this.caption) + "</button><div class='expandable-detail'>" + this.html + "</div>");
        return null;
    }

    public static String encodeTo(String buttonCaption, String html) {
        try {
            return new ExpandableDetailsNote(buttonCaption, html).encode();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to serialize " + String.valueOf(HyperlinkNote.class), e);
            return "";
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends ConsoleAnnotationDescriptor {
        @Override
        @NonNull
        public String getDisplayName() {
            return "Expandable details";
        }
    }
}

