/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.Messages;
import hudson.model.Computer;
import hudson.model.Node;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import jenkins.model.Jenkins;
import jenkins.security.ExtendedReadRedaction;
import org.apache.commons.io.IOUtils;
import org.kohsuke.args4j.Argument;

@Extension
public class GetNodeCommand
extends CLICommand {
    @Argument(metaVar="NODE", usage="Name of the node", required=true)
    public Node node;

    @Override
    public String getShortDescription() {
        return Messages.GetNodeCommand_ShortDescription();
    }

    @Override
    protected int run() throws IOException {
        this.node.checkPermission(Computer.EXTENDED_READ);
        if (this.node.hasPermission(Computer.CONFIGURE)) {
            Jenkins.XSTREAM2.toXMLUTF8(this.node, this.stdout);
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Jenkins.XSTREAM2.toXMLUTF8(this.node, baos);
            String xml = baos.toString(StandardCharsets.UTF_8);
            xml = ExtendedReadRedaction.applyAll(xml);
            IOUtils.write((String)xml, (OutputStream)this.stdout, (Charset)StandardCharsets.UTF_8);
        }
        return 0;
    }
}

