/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.remoting.shaded.org.jenkinsci.constant_pool_scanner;

import io.jenkins.remoting.shaded.org.jenkinsci.constant_pool_scanner.ClassConstant;
import io.jenkins.remoting.shaded.org.jenkinsci.constant_pool_scanner.ConstantPool;
import io.jenkins.remoting.shaded.org.jenkinsci.constant_pool_scanner.ConstantType;
import io.jenkins.remoting.shaded.org.jenkinsci.constant_pool_scanner.NameAndTypeConstant;
import io.jenkins.remoting.shaded.org.jenkinsci.constant_pool_scanner.StringConstant;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantPoolScanner {
    public static Set<String> dependencies(byte[] data) throws IOException {
        return ConstantPoolScanner.dependencies(new ByteArrayInputStream(data));
    }

    public static Set<String> dependencies(InputStream in) throws IOException {
        String s;
        ConstantPool pool = ConstantPoolScanner.parse(in, ConstantType.CLASS, ConstantType.NAME_AND_TYPE);
        TreeSet<String> result = new TreeSet<String>();
        for (ClassConstant classConstant : pool.list(ClassConstant.class)) {
            s = classConstant.get();
            while (s.charAt(0) == '[') {
                s = s.substring(1);
            }
            if (s.length() == 1) continue;
            String c = s.charAt(s.length() - 1) == ';' && s.charAt(0) == 'L' ? s.substring(1, s.length() - 1) : s;
            result.add(c.replace('/', '.'));
        }
        for (NameAndTypeConstant nameAndTypeConstant : pool.list(NameAndTypeConstant.class)) {
            s = nameAndTypeConstant.getDescriptor();
            int idx = 0;
            while ((idx = s.indexOf(76, idx)) != -1) {
                int semi = s.indexOf(59, idx);
                if (semi == -1) {
                    throw new IOException("Invalid type or descriptor: " + s);
                }
                result.add(s.substring(idx + 1, semi).replace('/', '.'));
                idx = semi;
            }
        }
        return result;
    }

    private ConstantPoolScanner() {
    }

    public static ConstantPool parse(byte[] source, ConstantType ... types) throws IOException {
        return ConstantPoolScanner.parse(new ByteArrayInputStream(source), types);
    }

    public static ConstantPool parse(InputStream source, ConstantType ... types) throws IOException {
        return ConstantPoolScanner.parse(new DataInputStream(source), Arrays.asList(types));
    }

    public static ConstantPool parse(DataInput s, Collection<ConstantType> _collect) throws IOException {
        ConstantPoolScanner.skip(s, 8);
        int size = s.readUnsignedShort() - 1;
        ConstantPool pool = new ConstantPool(size);
        EnumSet<ConstantType> collect = ConstantPoolScanner.transitiveClosureOf(_collect);
        block16: for (int i = 0; i < size; ++i) {
            byte tag = s.readByte();
            switch (tag) {
                case 1: {
                    if (collect.contains((Object)ConstantType.UTF8)) {
                        pool.utf8At((int)i).actual = s.readUTF();
                        continue block16;
                    }
                    ConstantPoolScanner.skip(s, s.readUnsignedShort());
                    continue block16;
                }
                case 7: {
                    if (collect.contains((Object)ConstantType.CLASS)) {
                        pool.classAt(i).set(pool.utf8At(ConstantPoolScanner.readIndex(s)));
                        continue block16;
                    }
                    ConstantPoolScanner.skip(s, 2);
                    continue block16;
                }
                case 3: {
                    if (collect.contains((Object)ConstantType.INTEGER)) {
                        pool.set(i, s.readInt());
                        continue block16;
                    }
                    ConstantPoolScanner.skip(s, 4);
                    continue block16;
                }
                case 4: {
                    if (collect.contains((Object)ConstantType.FLOAT)) {
                        pool.set(i, Float.valueOf(s.readFloat()));
                        continue block16;
                    }
                    ConstantPoolScanner.skip(s, 4);
                    continue block16;
                }
                case 9: {
                    if (collect.contains((Object)ConstantType.FIELD_REF)) {
                        pool.fieldRefAt(i).set(pool.classAt(ConstantPoolScanner.readIndex(s)), pool.nameAndTypeAt(ConstantPoolScanner.readIndex(s)));
                        continue block16;
                    }
                    ConstantPoolScanner.skip(s, 4);
                    continue block16;
                }
                case 10: {
                    if (collect.contains((Object)ConstantType.METHOD_REF)) {
                        pool.methodRefAt(i).set(pool.classAt(ConstantPoolScanner.readIndex(s)), pool.nameAndTypeAt(ConstantPoolScanner.readIndex(s)));
                        continue block16;
                    }
                    ConstantPoolScanner.skip(s, 4);
                    continue block16;
                }
                case 11: {
                    if (collect.contains((Object)ConstantType.INTERFACE_METHOD_REF)) {
                        pool.interfaceMethodRefAt(i).set(pool.classAt(ConstantPoolScanner.readIndex(s)), pool.nameAndTypeAt(ConstantPoolScanner.readIndex(s)));
                        continue block16;
                    }
                    ConstantPoolScanner.skip(s, 4);
                    continue block16;
                }
                case 12: {
                    if (collect.contains((Object)ConstantType.NAME_AND_TYPE)) {
                        pool.nameAndTypeAt(i).set(pool.utf8At(ConstantPoolScanner.readIndex(s)), pool.utf8At(ConstantPoolScanner.readIndex(s)));
                        continue block16;
                    }
                    ConstantPoolScanner.skip(s, 4);
                    continue block16;
                }
                case 8: {
                    if (collect.contains((Object)ConstantType.STRING)) {
                        pool.set(i, new StringConstant(pool.utf8At(ConstantPoolScanner.readIndex(s))));
                        continue block16;
                    }
                    ConstantPoolScanner.skip(s, 2);
                    continue block16;
                }
                case 5: {
                    if (collect.contains((Object)ConstantType.LONG)) {
                        pool.set(i, s.readLong());
                    } else {
                        ConstantPoolScanner.skip(s, 8);
                    }
                    ++i;
                    continue block16;
                }
                case 6: {
                    if (collect.contains((Object)ConstantType.DOUBLE)) {
                        pool.set(i, s.readDouble());
                    } else {
                        ConstantPoolScanner.skip(s, 8);
                    }
                    ++i;
                    continue block16;
                }
                case 15: {
                    ConstantPoolScanner.skip(s, 3);
                    continue block16;
                }
                case 16: {
                    ConstantPoolScanner.skip(s, 2);
                    continue block16;
                }
                case 18: {
                    ConstantPoolScanner.skip(s, 4);
                    continue block16;
                }
                default: {
                    throw new IOException("Unrecognized constant pool tag " + tag + " at index " + i + "; running constants: " + pool);
                }
            }
        }
        return pool;
    }

    private static EnumSet<ConstantType> transitiveClosureOf(Collection<ConstantType> collect) {
        EnumSet<ConstantType> subject = EnumSet.copyOf(collect);
        for (ConstantType c : collect) {
            subject.addAll(c.implies);
        }
        return subject;
    }

    private static void skip(DataInput source, int bytes) throws IOException {
        source.readFully(new byte[bytes]);
    }

    private static int readIndex(DataInput source) throws IOException {
        return source.readUnsignedShort() - 1;
    }
}

