/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.Command;
import hudson.remoting.CommandTransport;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.remoting.util.AnonymousClassWarnings;

public abstract class AbstractByteArrayCommandTransport
extends CommandTransport {
    protected Channel channel;
    private static final Logger LOGGER = Logger.getLogger(AbstractByteArrayCommandTransport.class.getName());

    public abstract void writeBlock(Channel var1, byte[] var2) throws IOException;

    public abstract void setup(ByteArrayReceiver var1);

    @Override
    public final void setup(Channel channel, CommandTransport.CommandReceiver receiver) {
        this.channel = channel;
        this.setup(new ByteArrayReceiverImpl(channel, receiver));
    }

    @Override
    public final void write(Command cmd, boolean last) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = AnonymousClassWarnings.checkingObjectOutputStream(baos);){
            cmd.writeTo(this.channel, oos);
        }
        byte[] block = baos.toByteArray();
        this.channel.notifyWrite(cmd, block.length);
        this.writeBlock(this.channel, block);
    }

    private static class ByteArrayReceiverImpl
    implements ByteArrayReceiver {
        private final Channel channel;
        private final CommandTransport.CommandReceiver receiver;

        public ByteArrayReceiverImpl(Channel channel, CommandTransport.CommandReceiver receiver) {
            this.channel = Objects.requireNonNull(channel);
            this.receiver = Objects.requireNonNull(receiver);
        }

        @Override
        public void handle(byte[] payload) {
            try {
                Command cmd = Command.readFrom(this.channel, payload);
                this.receiver.handle(cmd);
            }
            catch (IOException | ClassNotFoundException e) {
                LOGGER.log(Level.WARNING, "Failed to construct Command in channel " + this.channel.getName(), e);
            }
        }

        @Override
        public void terminate(IOException e) {
            this.receiver.terminate(e);
        }
    }

    public static interface ByteArrayReceiver {
        public void handle(byte[] var1);

        public void terminate(IOException var1);
    }
}

