/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.reactor;

import java.util.Collection;
import org.jvnet.hudson.reactor.Milestone;
import org.jvnet.hudson.reactor.Task;

public interface ReactorListener {
    public static final ReactorListener NOOP = new ReactorListener(){};

    default public void onTaskStarted(Task t) {
    }

    default public void onTaskCompleted(Task t) {
    }

    default public void onTaskFailed(Task t, Throwable err, boolean fatal) {
    }

    default public void onAttained(Milestone milestone) {
    }

    public static class Aggregator
    implements ReactorListener {
        private final Collection<ReactorListener> listeners;

        public Aggregator(Collection<ReactorListener> listeners) {
            this.listeners = listeners;
        }

        @Override
        public void onTaskStarted(Task t) {
            this.run(l -> l.onTaskStarted(t));
        }

        @Override
        public void onTaskCompleted(Task t) {
            this.run(l -> l.onTaskCompleted(t));
        }

        @Override
        public void onTaskFailed(Task t, Throwable err, boolean fatal) {
            this.run(l -> l.onTaskFailed(t, err, fatal));
        }

        @Override
        public void onAttained(Milestone milestone) {
            this.run(l -> l.onAttained(milestone));
        }

        private void run(ListenerAction action) {
            Throwable ex = null;
            for (ReactorListener listener : this.listeners) {
                try {
                    action.run(listener);
                }
                catch (Throwable x) {
                    if (ex == null) {
                        ex = x;
                        continue;
                    }
                    ex.addSuppressed(x);
                }
            }
            if (ex != null) {
                if (ex instanceof Error) {
                    throw (Error)ex;
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
            }
        }

        private static interface ListenerAction {
            public void run(ReactorListener var1);
        }
    }
}

