/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.framework.io;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class AtomicFileWriter
extends Writer {
    private final Writer core;
    private final File tmpFile;
    private final File destFile;

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Protected by checks at other layers.")
    public AtomicFileWriter(File f) throws IOException {
        this.tmpFile = File.createTempFile("atomic", null, f.getParentFile());
        this.destFile = f;
        this.core = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(this.tmpFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE), StandardCharsets.UTF_8));
    }

    @Override
    public void write(int c) throws IOException {
        this.core.write(c);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.core.write(str, off, len);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.core.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.core.flush();
    }

    @Override
    public void close() throws IOException {
        this.core.close();
    }

    public void commit() throws IOException {
        this.close();
        Path destFilePath = this.destFile.toPath();
        if (Files.exists(destFilePath, new LinkOption[0])) {
            Files.delete(destFilePath);
        }
        Files.move(this.tmpFile.toPath(), destFilePath, new CopyOption[0]);
    }

    public File getTemporaryFile() {
        return this.tmpFile;
    }
}

