/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.kohsuke.stapler.CompatibleFilter;
import org.kohsuke.stapler.UncaughtExceptionHandler;

public class UncaughtExceptionFilter
implements CompatibleFilter {
    private ServletContext context;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static boolean DISABLED = Boolean.getBoolean(UncaughtExceptionFilter.class.getName() + ".disabled");

    public void init(FilterConfig filterConfig) throws ServletException {
        this.context = filterConfig.getServletContext();
    }

    public void doFilter(ServletRequest req, ServletResponse rsp, FilterChain filterChain) throws IOException, ServletException {
        try {
            filterChain.doFilter(req, rsp);
        }
        catch (ServletException | IOException | Error | RuntimeException e) {
            if (DISABLED) {
                throw e;
            }
            this.reportException(e, (HttpServletRequest)req, (HttpServletResponse)rsp);
        }
    }

    private void reportException(Throwable e, HttpServletRequest req, HttpServletResponse rsp) throws IOException, ServletException {
        UncaughtExceptionFilter.getUncaughtExceptionHandler(this.context).reportException(e, this.context, req, rsp);
    }

    public void destroy() {
    }

    public static void setUncaughtExceptionHandler(ServletContext context, UncaughtExceptionHandler handler) {
        context.setAttribute(UncaughtExceptionHandler.class.getName(), (Object)handler);
    }

    public static UncaughtExceptionHandler getUncaughtExceptionHandler(ServletContext context) {
        UncaughtExceptionHandler h = (UncaughtExceptionHandler)context.getAttribute(UncaughtExceptionHandler.class.getName());
        if (h == null) {
            h = UncaughtExceptionHandler.DEFAULT;
        }
        return h;
    }
}

