/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.bouncycastle.asn1.x500;

import io.jenkins.cli.shaded.org.bouncycastle.asn1.ASN1Encodable;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.ASN1Object;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.ASN1Primitive;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.ASN1Sequence;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.DERSequence;

public class AttributeTypeAndValue
extends ASN1Object {
    private ASN1ObjectIdentifier type;
    private ASN1Encodable value;

    private AttributeTypeAndValue(ASN1Sequence aSN1Sequence) {
        this.type = (ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0);
        this.value = aSN1Sequence.getObjectAt(1);
    }

    public static AttributeTypeAndValue getInstance(Object object) {
        if (object instanceof AttributeTypeAndValue) {
            return (AttributeTypeAndValue)object;
        }
        if (object != null) {
            return new AttributeTypeAndValue(ASN1Sequence.getInstance(object));
        }
        throw new IllegalArgumentException("null value in getInstance()");
    }

    public AttributeTypeAndValue(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.type = aSN1ObjectIdentifier;
        this.value = aSN1Encodable;
    }

    public ASN1ObjectIdentifier getType() {
        return this.type;
    }

    public ASN1Encodable getValue() {
        return this.value;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.type, this.value);
    }
}

