/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.util.io.output;

import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.LineDataConsumer;
import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.function.BooleanSupplier;

public interface LineLevelAppender
extends LineDataConsumer,
Closeable {
    public static final int TYPICAL_LINE_LENGTH = 80;
    public static final LineLevelAppender EMPTY = new LineLevelAppender(){

        @Override
        public void writeLineData(CharSequence lineData) throws IOException {
        }

        @Override
        public boolean isWriteEnabled() {
            return false;
        }

        @Override
        public void close() throws IOException {
        }

        public String toString() {
            return "EMPTY";
        }
    };

    public boolean isWriteEnabled();

    @Override
    default public void consume(CharSequence lineData) throws IOException {
        this.writeLineData(lineData);
    }

    public void writeLineData(CharSequence var1) throws IOException;

    public static LineLevelAppender wrap(Appendable appendable) {
        return LineLevelAppender.wrap(appendable, () -> true);
    }

    public static LineLevelAppender wrap(final Appendable appendable, final BooleanSupplier writeEnabled) {
        Objects.requireNonNull(appendable, "No appendable to wrap");
        return new LineLevelAppender(){
            private boolean writtenFirstLine;

            @Override
            public void close() throws IOException {
                if (appendable instanceof Closeable) {
                    ((Closeable)((Object)appendable)).close();
                }
            }

            @Override
            public void writeLineData(CharSequence lineData) throws IOException {
                if (this.writtenFirstLine) {
                    appendable.append(System.lineSeparator());
                }
                appendable.append(lineData);
                this.writtenFirstLine = true;
            }

            @Override
            public boolean isWriteEnabled() {
                return writeEnabled.getAsBoolean();
            }

            public String toString() {
                return appendable.toString();
            }
        };
    }
}

