/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.config.keys;

import io.jenkins.cli.shaded.org.apache.sshd.common.NamedResource;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionContext;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.IoUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.resource.IoResource;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.resource.PathResource;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.resource.URLResource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.List;
import java.util.Objects;

public interface PublicKeyRawDataReader<PUB extends PublicKey> {
    default public PUB readPublicKey(SessionContext session, Path path, OpenOption ... options) throws IOException, GeneralSecurityException {
        return this.readPublicKey(session, path, StandardCharsets.UTF_8, options);
    }

    default public PUB readPublicKey(SessionContext session, Path path, Charset cs, OpenOption ... options) throws IOException, GeneralSecurityException {
        return this.readPublicKey(session, new PathResource(path, options), cs);
    }

    default public PUB readPublicKey(SessionContext session, URL url) throws IOException, GeneralSecurityException {
        return this.readPublicKey(session, url, StandardCharsets.UTF_8);
    }

    default public PUB readPublicKey(SessionContext session, URL url, Charset cs) throws IOException, GeneralSecurityException {
        return this.readPublicKey(session, new URLResource(url), cs);
    }

    default public PUB readPublicKey(SessionContext session, IoResource<?> resource) throws IOException, GeneralSecurityException {
        return this.readPublicKey(session, resource, StandardCharsets.UTF_8);
    }

    default public PUB readPublicKey(SessionContext session, IoResource<?> resource, Charset cs) throws IOException, GeneralSecurityException {
        try (InputStream stream = Objects.requireNonNull(resource, "No resource data").openInputStream();){
            PUB PUB = this.readPublicKey(session, resource, stream, cs);
            return PUB;
        }
    }

    default public PUB readPublicKey(SessionContext session, NamedResource resourceKey, InputStream stream) throws IOException, GeneralSecurityException {
        return this.readPublicKey(session, resourceKey, stream, StandardCharsets.UTF_8);
    }

    default public PUB readPublicKey(SessionContext session, NamedResource resourceKey, InputStream stream, Charset cs) throws IOException, GeneralSecurityException {
        try (InputStreamReader reader = new InputStreamReader(Objects.requireNonNull(stream, "No stream instance"), Objects.requireNonNull(cs, "No charset"));){
            PUB PUB = this.readPublicKey(session, resourceKey, reader);
            return PUB;
        }
    }

    default public PUB readPublicKey(SessionContext session, NamedResource resourceKey, Reader rdr) throws IOException, GeneralSecurityException {
        try (BufferedReader br = new BufferedReader(Objects.requireNonNull(rdr, "No reader instance"), 8192);){
            PUB PUB = this.readPublicKey(session, resourceKey, br);
            return PUB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public PUB readPublicKey(SessionContext session, NamedResource resourceKey, BufferedReader rdr) throws IOException, GeneralSecurityException {
        List<String> lines = IoUtils.readAllLines(rdr);
        try {
            PUB PUB = this.readPublicKey(session, resourceKey, lines);
            return PUB;
        }
        finally {
            lines.clear();
        }
    }

    public PUB readPublicKey(SessionContext var1, NamedResource var2, List<String> var3) throws IOException, GeneralSecurityException;
}

