/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson;

import java.io.IOException;
import java.io.Serializable;

public class MemoryUsage
implements Serializable {
    public final long totalPhysicalMemory;
    public final long availablePhysicalMemory;
    public final long totalSwapSpace;
    public final long availableSwapSpace;
    private static final long serialVersionUID = 1L;

    public MemoryUsage(long totalPhysicalMemory, long availablePhysicalMemory, long totalSwapSpace, long availableSwapSpace) {
        this.totalPhysicalMemory = totalPhysicalMemory;
        this.availablePhysicalMemory = availablePhysicalMemory;
        this.totalSwapSpace = totalSwapSpace;
        this.availableSwapSpace = availableSwapSpace;
    }

    MemoryUsage(long[] v) throws IOException {
        this(v[0], v[1], v[2], v[3]);
        if (!MemoryUsage.hasData(v)) {
            throw new IOException("No data available");
        }
    }

    public String toString() {
        return String.format("Memory:%d/%dMB  Swap:%d/%dMB", MemoryUsage.toMB(this.availablePhysicalMemory), MemoryUsage.toMB(this.totalPhysicalMemory), MemoryUsage.toMB(this.availableSwapSpace), MemoryUsage.toMB(this.totalSwapSpace));
    }

    private static long toMB(long l) {
        return l / 0x100000L;
    }

    static boolean hasData(long[] values) {
        for (long v : values) {
            if (v == -1L) continue;
            return true;
        }
        return false;
    }
}

