/*
 * Decompiled with CFR 0.152.
 */
package winstone.cmdline;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import winstone.Launcher;
import winstone.Logger;
import winstone.cmdline.Option;

public class CmdLineParser {
    private final List<Option<?>> options;

    public CmdLineParser(List<Option<?>> options) {
        this.options = options;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="TODO needs triage")
    public Map<String, String> parse(String[] argv, String nonSwitchArgName) throws IOException {
        HashMap<String, String> args = new HashMap<String, String>();
        String embeddedPropertiesFilename = Launcher.RESOURCES.getString("Launcher.EmbeddedPropertiesFile");
        try (InputStream embeddedPropsStream = Launcher.class.getResourceAsStream(embeddedPropertiesFilename);){
            if (embeddedPropsStream != null) {
                CmdLineParser.loadPropsFromStream(embeddedPropsStream, args);
            }
        }
        String configFilename = Launcher.RESOURCES.getString("Launcher.DefaultPropertyFile");
        for (String option : argv) {
            if (option.startsWith("--")) {
                int equalPos = option.indexOf(61);
                String paramName = option.substring(2, equalPos == -1 ? option.length() : equalPos);
                Option<?> opt = this.toOption(paramName);
                if (opt == null) {
                    throw new IllegalArgumentException(Launcher.RESOURCES.getString("CmdLineParser.UnrecognizedOption", option));
                }
                if (equalPos != -1) {
                    args.put(paramName, option.substring(equalPos + 1));
                } else if (opt.type == Boolean.class) {
                    args.put(paramName, "true");
                } else {
                    throw new IllegalArgumentException(Launcher.RESOURCES.getString("CmdLineParser.OperandExpected", option));
                }
                if (!paramName.equals(Option.CONFIG.name)) continue;
                configFilename = (String)args.get(paramName);
                continue;
            }
            if (args.containsKey(nonSwitchArgName)) {
                throw new IllegalArgumentException(Launcher.RESOURCES.getString("CmdLineParser.MultipleArgs", option));
            }
            args.put(nonSwitchArgName, option);
        }
        File configFile = new File(configFilename);
        if (configFile.exists() && configFile.isFile()) {
            try (FileInputStream inConfig = new FileInputStream(configFile);){
                CmdLineParser.loadPropsFromStream(inConfig, args);
                ((InputStream)inConfig).close();
                Launcher.initLogger(args);
                Logger.log(Level.FINER, Launcher.RESOURCES, "Launcher.UsingPropertyFile", (Object)configFilename);
            }
        } else {
            Launcher.initLogger(args);
        }
        return args;
    }

    private static void loadPropsFromStream(InputStream inConfig, Map<String, String> args) throws IOException {
        Properties props = new Properties();
        props.load(inConfig);
        for (Object o : props.keySet()) {
            String key = (String)o;
            if (args.containsKey(key.trim())) continue;
            args.put(key.trim(), props.getProperty(key).trim());
        }
        props.clear();
    }

    private Option<?> toOption(String paramName) {
        for (Option<?> o : this.options) {
            if (o.isWildcard() && paramName.startsWith(o.name)) {
                return o;
            }
            if (o.isWildcard() || !paramName.equals(o.name)) continue;
            return o;
        }
        return null;
    }
}

