/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.TagLibrary;
import org.apache.commons.jelly.impl.DynamicTag;
import org.apache.commons.jelly.impl.TagFactory;
import org.apache.commons.jelly.impl.TagScript;
import org.xml.sax.Attributes;

public class DynamicTagLibrary
extends TagLibrary {
    private String uri;
    private Map templates = new HashMap();
    private TagLibrary parent;

    public DynamicTagLibrary() {
    }

    public DynamicTagLibrary(String uri) {
        this.uri = uri;
    }

    @Override
    public TagScript createTagScript(String name, Attributes attributes) throws JellyException {
        return new TagScript(new TagFactory(){

            @Override
            public Tag createTag(String name, Attributes attributes) throws JellyException {
                return DynamicTagLibrary.this.createTag(name, attributes);
            }
        });
    }

    @Override
    public Tag createTag(String name, Attributes attributes) throws JellyException {
        Object value = this.templates.get(name);
        if (value instanceof Script) {
            Script template = (Script)value;
            return new DynamicTag(template);
        }
        if (value instanceof TagFactory) {
            TagFactory factory = (TagFactory)value;
            return factory.createTag(name, attributes);
        }
        if (this.parent != null) {
            return this.parent.createTag(name, attributes);
        }
        return null;
    }

    public void registerDynamicTag(String name, Script template) {
        this.templates.put(name, template);
    }

    public void registerBeanTag(String name, TagFactory factory) {
        this.templates.put(name, factory);
    }

    public Script getDynamicTag(String name) {
        Object result = this.templates.get(name);
        return result instanceof Script ? (Script)result : null;
    }

    public DynamicTagLibrary find(String name) {
        DynamicTagLibrary result = null;
        if (this.templates.get(name) != null) {
            result = this;
        } else if (this.parent instanceof DynamicTagLibrary) {
            result = ((DynamicTagLibrary)this.parent).find(name);
        }
        return result;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public TagLibrary getParent() {
        return this.parent;
    }

    public void setParent(TagLibrary parent) {
        this.parent = parent;
    }
}

