/*
 * Decompiled with CFR 0.152.
 */
package com.rm5248.dbusjava.nativefd;

import java.util.ArrayList;
import java.util.List;
import org.freedesktop.dbus.FileDescriptor;

public class MsgHdr {
    private List<byte[]> m_messages = new ArrayList<byte[]>();
    private List<FileDescriptor> m_fileDescriptors;

    public MsgHdr() {
        this.m_fileDescriptors = new ArrayList<FileDescriptor>();
    }

    public MsgHdr(byte[] data, int[] fileDescriptors) {
        this.m_messages.add(data);
        this.m_fileDescriptors = new ArrayList<FileDescriptor>(fileDescriptors == null ? 1 : fileDescriptors.length);
        if (fileDescriptors != null) {
            for (int x = 0; x < fileDescriptors.length; ++x) {
                this.m_fileDescriptors.add(new FileDescriptor(fileDescriptors[x]));
            }
        }
    }

    public void addMessageToSend(byte[] msg) {
        this.m_messages.add(msg);
    }

    public void addFiledescriptorToSend(FileDescriptor fd) {
        this.m_fileDescriptors.add(fd);
    }

    public List<byte[]> getMessages() {
        return this.m_messages;
    }

    public List<FileDescriptor> getFileDescriptors() {
        return this.m_fileDescriptors;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MsgHdr: ").append(System.lineSeparator()).append("  ").append("msg_iov=[").append(System.lineSeparator());
        for (byte[] message : this.m_messages) {
            builder.append("    ").append("len: ").append(message.length);
            builder.append(System.lineSeparator());
        }
        builder.append("],").append(System.lineSeparator());
        builder.append("  ").append("msg_control=[").append(System.lineSeparator());
        for (FileDescriptor fd : this.m_fileDescriptors) {
            builder.append("    ").append(fd);
            builder.append(System.lineSeparator());
        }
        builder.append("],").append(System.lineSeparator());
        return builder.toString();
    }
}

