use crate::data::caniuse::features::Feature;
static KEYS: &[&str] = &[
    "aac",
    "abortcontroller",
    "accelerometer",
    "addeventlistener",
    "ambient-light",
    "apng",
    "array-find",
    "array-find-index",
    "array-flat",
    "array-includes",
    "arrow-functions",
    "asmjs",
    "async-clipboard",
    "async-functions",
    "atob-btoa",
    "audio",
    "audio-api",
    "audiotracks",
    "autofocus",
    "auxclick",
    "av1",
    "avif",
    "background-attachment",
    "background-clip-text",
    "background-img-opts",
    "background-position-x-y",
    "background-repeat-round-space",
    "background-sync",
    "battery-status",
    "beacon",
    "beforeafterprint",
    "bigint",
    "blobbuilder",
    "bloburls",
    "border-image",
    "border-radius",
    "broadcastchannel",
    "brotli",
    "calc",
    "canvas",
    "canvas-blending",
    "canvas-text",
    "ch-unit",
    "chacha20-poly1305",
    "channel-messaging",
    "childnode-remove",
    "classlist",
    "client-hints-dpr-width-viewport",
    "clipboard",
    "colr",
    "colr-v1",
    "comparedocumentposition",
    "console-basic",
    "console-time",
    "const",
    "constraint-validation",
    "contenteditable",
    "contentsecuritypolicy",
    "contentsecuritypolicy2",
    "cookie-store-api",
    "cors",
    "createimagebitmap",
    "credential-management",
    "cross-document-view-transitions",
    "cryptography",
    "css-all",
    "css-anchor-positioning",
    "css-animation",
    "css-any-link",
    "css-appearance",
    "css-at-counter-style",
    "css-backdrop-filter",
    "css-background-offsets",
    "css-backgroundblendmode",
    "css-boxdecorationbreak",
    "css-boxshadow",
    "css-canvas",
    "css-caret-color",
    "css-cascade-layers",
    "css-cascade-scope",
    "css-case-insensitive",
    "css-clip-path",
    "css-color-adjust",
    "css-color-function",
    "css-conic-gradients",
    "css-container-queries",
    "css-container-queries-style",
    "css-container-query-units",
    "css-containment",
    "css-content-visibility",
    "css-counters",
    "css-crisp-edges",
    "css-cross-fade",
    "css-default-pseudo",
    "css-descendant-gtgt",
    "css-deviceadaptation",
    "css-dir-pseudo",
    "css-display-contents",
    "css-element-function",
    "css-env-function",
    "css-exclusions",
    "css-featurequeries",
    "css-filter-function",
    "css-filters",
    "css-first-letter",
    "css-first-line",
    "css-fixed",
    "css-focus-visible",
    "css-focus-within",
    "css-font-palette",
    "css-font-rendering-controls",
    "css-font-stretch",
    "css-gencontent",
    "css-gradients",
    "css-grid",
    "css-hanging-punctuation",
    "css-has",
    "css-hyphens",
    "css-if",
    "css-image-orientation",
    "css-image-set",
    "css-in-out-of-range",
    "css-indeterminate-pseudo",
    "css-initial-letter",
    "css-initial-value",
    "css-lch-lab",
    "css-letter-spacing",
    "css-line-clamp",
    "css-logical-props",
    "css-marker-pseudo",
    "css-masks",
    "css-matches-pseudo",
    "css-math-functions",
    "css-media-interaction",
    "css-media-range-syntax",
    "css-media-resolution",
    "css-mediaqueries",
    "css-mixblendmode",
    "css-motion-paths",
    "css-namespaces",
    "css-nesting",
    "css-not-sel-list",
    "css-nth-child-of",
    "css-opacity",
    "css-optional-pseudo",
    "css-overflow",
    "css-overflow-anchor",
    "css-overflow-overlay",
    "css-overscroll-behavior",
    "css-page-break",
    "css-paged-media",
    "css-paint-api",
    "css-placeholder",
    "css-placeholder-shown",
    "css-read-only-write",
    "css-rebeccapurple",
    "css-reflections",
    "css-regions",
    "css-relative-colors",
    "css-repeating-gradients",
    "css-resize",
    "css-revert-value",
    "css-rrggbbaa",
    "css-scroll-behavior",
    "css-scrollbar",
    "css-sel2",
    "css-sel3",
    "css-selection",
    "css-shapes",
    "css-snappoints",
    "css-sticky",
    "css-subgrid",
    "css-supports-api",
    "css-table",
    "css-text-align-last",
    "css-text-box-trim",
    "css-text-indent",
    "css-text-justify",
    "css-text-orientation",
    "css-text-wrap-balance",
    "css-textshadow",
    "css-touch-action",
    "css-transitions",
    "css-unset-value",
    "css-variables",
    "css-when-else",
    "css-widows-orphans",
    "css-writing-mode",
    "css-zoom",
    "css3-attr",
    "css3-boxsizing",
    "css3-colors",
    "css3-cursors",
    "css3-cursors-grab",
    "css3-cursors-newer",
    "css3-tabsize",
    "currentcolor",
    "custom-elements",
    "custom-elementsv1",
    "customevent",
    "datalist",
    "dataset",
    "datauri",
    "date-tolocaledatestring",
    "declarative-shadow-dom",
    "decorators",
    "details",
    "deviceorientation",
    "devicepixelratio",
    "dialog",
    "dispatchevent",
    "dnssec",
    "do-not-track",
    "document-currentscript",
    "document-evaluate-xpath",
    "document-execcommand",
    "document-policy",
    "document-scrollingelement",
    "documenthead",
    "dom-manip-convenience",
    "dom-range",
    "domcontentloaded",
    "dommatrix",
    "download",
    "dragndrop",
    "element-closest",
    "element-from-point",
    "element-scroll-methods",
    "eme",
    "eot",
    "es5",
    "es6",
    "es6-class",
    "es6-generators",
    "es6-module",
    "es6-module-dynamic-import",
    "es6-number",
    "es6-string-includes",
    "eventsource",
    "extended-system-fonts",
    "feature-policy",
    "fetch",
    "fieldset-disabled",
    "fileapi",
    "filereader",
    "filereadersync",
    "filesystem",
    "flac",
    "flexbox",
    "flexbox-gap",
    "flow-root",
    "focusin-focusout-events",
    "font-family-system-ui",
    "font-feature",
    "font-kerning",
    "font-loading",
    "font-size-adjust",
    "font-smooth",
    "font-unicode-range",
    "font-variant-alternates",
    "font-variant-numeric",
    "fontface",
    "form-attribute",
    "form-submit-attributes",
    "form-validation",
    "fullscreen",
    "gamepad",
    "geolocation",
    "getboundingclientrect",
    "getcomputedstyle",
    "getelementsbyclassname",
    "getrandomvalues",
    "gyroscope",
    "hardwareconcurrency",
    "hashchange",
    "heif",
    "hevc",
    "hidden",
    "high-resolution-time",
    "history",
    "html-media-capture",
    "html5semantic",
    "http-live-streaming",
    "http2",
    "http3",
    "iframe-sandbox",
    "iframe-seamless",
    "iframe-srcdoc",
    "imagecapture",
    "ime",
    "img-naturalwidth-naturalheight",
    "import-maps",
    "imports",
    "indeterminate-checkbox",
    "indexeddb",
    "indexeddb2",
    "inline-block",
    "innertext",
    "input-autocomplete-onoff",
    "input-color",
    "input-datetime",
    "input-email-tel-url",
    "input-event",
    "input-file-accept",
    "input-file-directory",
    "input-file-multiple",
    "input-inputmode",
    "input-minlength",
    "input-number",
    "input-pattern",
    "input-placeholder",
    "input-range",
    "input-search",
    "input-selection",
    "insert-adjacent",
    "insertadjacenthtml",
    "internationalization",
    "intersectionobserver",
    "intersectionobserver-v2",
    "intl-pluralrules",
    "intrinsic-width",
    "jpeg2000",
    "jpegxl",
    "jpegxr",
    "js-regexp-lookbehind",
    "json",
    "justify-content-space-evenly",
    "kerning-pairs-ligatures",
    "keyboardevent-charcode",
    "keyboardevent-code",
    "keyboardevent-getmodifierstate",
    "keyboardevent-key",
    "keyboardevent-location",
    "keyboardevent-which",
    "lazyload",
    "let",
    "link-icon-png",
    "link-icon-svg",
    "link-rel-dns-prefetch",
    "link-rel-modulepreload",
    "link-rel-preconnect",
    "link-rel-prefetch",
    "link-rel-preload",
    "link-rel-prerender",
    "loading-lazy-attr",
    "localecompare",
    "magnetometer",
    "matchesselector",
    "matchmedia",
    "mathml",
    "maxlength",
    "media-fragments",
    "mediacapture-fromelement",
    "mediarecorder",
    "mediasource",
    "menu",
    "meta-theme-color",
    "meter",
    "midi",
    "minmaxwh",
    "mp3",
    "mpeg-dash",
    "mpeg4",
    "multibackgrounds",
    "multicolumn",
    "mutation-events",
    "mutationobserver",
    "namevalue-storage",
    "native-filesystem-api",
    "nav-timing",
    "netinfo",
    "notifications",
    "object-entries",
    "object-fit",
    "object-observe",
    "object-values",
    "objectrtc",
    "offline-apps",
    "offscreencanvas",
    "ogg-vorbis",
    "ogv",
    "ol-reversed",
    "once-event-listener",
    "online-status",
    "opus",
    "orientation-sensor",
    "outline",
    "pad-start-end",
    "page-transition-events",
    "pagevisibility",
    "passive-event-listener",
    "passkeys",
    "path2d",
    "payment-request",
    "pdf-viewer",
    "permissions-api",
    "permissions-policy",
    "picture",
    "picture-in-picture",
    "ping",
    "png-alpha",
    "pointer",
    "pointer-events",
    "pointerlock",
    "portals",
    "prefers-color-scheme",
    "prefers-reduced-motion",
    "progress",
    "promise-finally",
    "promises",
    "proximity",
    "proxy",
    "publickeypinning",
    "push-api",
    "queryselector",
    "readonly-attr",
    "referrer-policy",
    "registerprotocolhandler",
    "rel-noopener",
    "rel-noreferrer",
    "rellist",
    "rem",
    "requestanimationframe",
    "requestidlecallback",
    "resizeobserver",
    "resource-timing",
    "rest-parameters",
    "rtcpeerconnection",
    "ruby",
    "run-in",
    "same-site-cookie-attribute",
    "screen-orientation",
    "script-async",
    "script-defer",
    "scrollintoview",
    "scrollintoviewifneeded",
    "sdch",
    "selection-api",
    "selectlist",
    "server-timing",
    "serviceworkers",
    "setimmediate",
    "shadowdom",
    "shadowdomv1",
    "sharedarraybuffer",
    "sharedworkers",
    "sni",
    "spdy",
    "speech-recognition",
    "speech-synthesis",
    "spellcheck-attribute",
    "sql-storage",
    "srcset",
    "stream",
    "streams",
    "stricttransportsecurity",
    "style-scoped",
    "subresource-integrity",
    "svg",
    "svg-css",
    "svg-filters",
    "svg-fonts",
    "svg-fragment",
    "svg-html",
    "svg-html5",
    "svg-img",
    "svg-smil",
    "sxg",
    "tabindex-attr",
    "template",
    "template-literals",
    "temporal",
    "text-decoration",
    "text-emphasis",
    "text-overflow",
    "text-size-adjust",
    "text-stroke",
    "textcontent",
    "textencoder",
    "tls1-1",
    "tls1-2",
    "tls1-3",
    "touch",
    "transforms2d",
    "transforms3d",
    "trusted-types",
    "ttf",
    "typedarrays",
    "u2f",
    "unhandledrejection",
    "upgradeinsecurerequests",
    "url",
    "url-scroll-to-text-fragment",
    "urlsearchparams",
    "use-strict",
    "user-select-none",
    "user-timing",
    "variable-fonts",
    "vector-effect",
    "vibration",
    "video",
    "videotracks",
    "view-transitions",
    "viewport-unit-variants",
    "viewport-units",
    "wai-aria",
    "wake-lock",
    "wasm",
    "wasm-bigint",
    "wasm-bulk-memory",
    "wasm-multi-value",
    "wasm-mutable-globals",
    "wasm-nontrapping-fptoint",
    "wasm-reference-types",
    "wasm-signext",
    "wasm-simd",
    "wasm-threads",
    "wav",
    "wbr-element",
    "web-animation",
    "web-bluetooth",
    "web-serial",
    "web-share",
    "webauthn",
    "webcodecs",
    "webgl",
    "webgl2",
    "webgpu",
    "webhid",
    "webkit-user-drag",
    "webm",
    "webnfc",
    "webp",
    "websockets",
    "webtransport",
    "webusb",
    "webvr",
    "webvtt",
    "webworkers",
    "webxr",
    "will-change",
    "woff",
    "woff2",
    "word-break",
    "wordwrap",
    "x-doc-messaging",
    "x-frame-options",
    "xhr2",
    "xhtml",
    "xhtmlsmil",
    "xml-serializer",
    "zstd",
];
static RANGES: &[u32] = &[
    0u32, 2256u32, 3896u32, 4671u32, 7121u32, 7279u32, 9283u32, 11258u32, 13242u32, 14829u32,
    16725u32, 18684u32, 20275u32, 21820u32, 23585u32, 26005u32, 28431u32, 30585u32, 31143u32,
    33179u32, 34561u32, 35721u32, 36771u32, 39070u32, 41254u32, 43686u32, 45914u32, 48018u32,
    49000u32, 50204u32, 52132u32, 53841u32, 55360u32, 57649u32, 59927u32, 62342u32, 64762u32,
    66399u32, 68227u32, 70465u32, 72915u32, 75033u32, 77441u32, 79653u32, 81516u32, 83754u32,
    85893u32, 88237u32, 89255u32, 91485u32, 93194u32, 93928u32, 96254u32, 98615u32, 100968u32,
    103392u32, 105687u32, 108087u32, 110350u32, 112329u32, 113121u32, 115490u32, 117185u32,
    118324u32, 118624u32, 120643u32, 122636u32, 122886u32, 125238u32, 127447u32, 129796u32,
    131036u32, 132499u32, 134748u32, 136758u32, 138912u32, 141328u32, 142142u32, 143859u32,
    144908u32, 145351u32, 147208u32, 149378u32, 151121u32, 152125u32, 153636u32, 154522u32,
    155025u32, 155911u32, 157468u32, 158381u32, 160833u32, 162966u32, 164680u32, 166924u32,
    166931u32, 167005u32, 167969u32, 169678u32, 170186u32, 171792u32, 171835u32, 173944u32,
    174430u32, 176652u32, 179056u32, 181516u32, 183943u32, 185421u32, 187138u32, 188104u32,
    189780u32, 191761u32, 194213u32, 196599u32, 198393u32, 198861u32, 199738u32, 201768u32,
    201844u32, 203533u32, 205463u32, 207724u32, 209995u32, 210895u32, 213222u32, 214094u32,
    216517u32, 218581u32, 220901u32, 222344u32, 224657u32, 226876u32, 228362u32, 230233u32,
    231249u32, 233673u32, 236117u32, 238080u32, 239640u32, 242070u32, 242792u32, 244215u32,
    245250u32, 247710u32, 250071u32, 252531u32, 253800u32, 254827u32, 256339u32, 258789u32,
    260574u32, 261450u32, 263729u32, 265730u32, 268044u32, 270072u32, 271879u32, 272027u32,
    272623u32, 274957u32, 276867u32, 278366u32, 280084u32, 281673u32, 283574u32, 286028u32,
    288472u32, 290533u32, 292431u32, 294172u32, 296074u32, 296951u32, 299065u32, 301517u32,
    303306u32, 303486u32, 305946u32, 306337u32, 308197u32, 308809u32, 311251u32, 313000u32,
    315409u32, 317384u32, 319291u32, 319292u32, 321067u32, 323271u32, 325219u32, 325316u32,
    327766u32, 330214u32, 332102u32, 333925u32, 335757u32, 337999u32, 340435u32, 340812u32,
    342556u32, 344895u32, 347051u32, 349511u32, 351963u32, 354295u32, 355265u32, 355266u32,
    357369u32, 359454u32, 361789u32, 363351u32, 365783u32, 368243u32, 370078u32, 372229u32,
    374655u32, 377003u32, 377651u32, 379552u32, 381933u32, 383730u32, 386180u32, 388630u32,
    390858u32, 392930u32, 394939u32, 396892u32, 399251u32, 401027u32, 402993u32, 403011u32,
    405461u32, 407665u32, 409588u32, 411570u32, 413266u32, 414907u32, 417061u32, 419010u32,
    421350u32, 421716u32, 423344u32, 425265u32, 427583u32, 429918u32, 432250u32, 434516u32,
    435691u32, 437501u32, 439879u32, 441269u32, 442937u32, 445100u32, 446926u32, 449158u32,
    451216u32, 453159u32, 454057u32, 455738u32, 457973u32, 459263u32, 461123u32, 463558u32,
    465906u32, 468239u32, 470625u32, 472768u32, 474780u32, 477178u32, 479606u32, 482054u32,
    484500u32, 486699u32, 487474u32, 489223u32, 491612u32, 491787u32, 492850u32, 495189u32,
    497359u32, 499708u32, 500229u32, 502677u32, 503464u32, 505431u32, 506661u32, 508957u32,
    508958u32, 511095u32, 512041u32, 512078u32, 514528u32, 515575u32, 515926u32, 518071u32,
    520307u32, 522148u32, 524608u32, 526917u32, 529312u32, 531372u32, 533467u32, 535882u32,
    538208u32, 540395u32, 541943u32, 544207u32, 545705u32, 547575u32, 549905u32, 552254u32,
    554657u32, 557015u32, 559310u32, 561716u32, 564024u32, 566430u32, 568508u32, 570255u32,
    571071u32, 572686u32, 574874u32, 575321u32, 575496u32, 575541u32, 576923u32, 579339u32,
    581095u32, 583382u32, 585701u32, 587398u32, 589503u32, 591447u32, 593743u32, 596134u32,
    596171u32, 598102u32, 600403u32, 601692u32, 603638u32, 604820u32, 606530u32, 608274u32,
    609951u32, 611129u32, 612488u32, 614874u32, 614875u32, 617248u32, 619554u32, 621105u32,
    623541u32, 625634u32, 627198u32, 628947u32, 630912u32, 631145u32, 631818u32, 634042u32,
    635239u32, 637693u32, 640053u32, 640078u32, 642371u32, 644793u32, 647202u32, 649282u32,
    651491u32, 653905u32, 654515u32, 656760u32, 657721u32, 659558u32, 661361u32, 663451u32,
    663547u32, 665350u32, 665372u32, 666582u32, 667819u32, 669848u32, 671131u32, 673299u32,
    675090u32, 677402u32, 679425u32, 680200u32, 682645u32, 684429u32, 686746u32, 688985u32,
    690811u32, 691592u32, 693612u32, 695252u32, 697284u32, 698939u32, 699490u32, 701450u32,
    703008u32, 704730u32, 707184u32, 708899u32, 711238u32, 712909u32, 712910u32, 714411u32,
    715995u32, 718306u32, 719967u32, 722037u32, 722506u32, 724453u32, 724845u32, 726439u32,
    728877u32, 731195u32, 733275u32, 734786u32, 736593u32, 738794u32, 740702u32, 743071u32,
    745334u32, 746696u32, 748242u32, 750286u32, 752254u32, 754291u32, 756510u32, 756830u32,
    758559u32, 760319u32, 762622u32, 764941u32, 767303u32, 769051u32, 769509u32, 771867u32,
    771868u32, 773279u32, 775149u32, 775192u32, 775611u32, 777374u32, 778738u32, 780535u32,
    782967u32, 783876u32, 784772u32, 786709u32, 789100u32, 790379u32, 792383u32, 794468u32,
    796209u32, 798468u32, 798581u32, 800429u32, 802867u32, 805287u32, 807657u32, 808486u32,
    810605u32, 812999u32, 815328u32, 817750u32, 820120u32, 820939u32, 823122u32, 825238u32,
    827197u32, 827240u32, 829168u32, 831217u32, 833655u32, 834972u32, 837163u32, 839595u32,
    841573u32, 843743u32, 845875u32, 847449u32, 849423u32, 851839u32, 854138u32, 854906u32,
    857319u32, 859650u32, 860716u32, 862452u32, 864337u32, 866410u32, 867460u32, 869346u32,
    871665u32, 874026u32, 876061u32, 877732u32, 879948u32, 881566u32, 883982u32, 884522u32,
    885040u32, 885961u32, 888157u32, 890563u32, 891561u32, 893303u32, 894611u32, 895990u32,
    897336u32, 898869u32, 900293u32, 901469u32, 902917u32, 904000u32, 905397u32, 907769u32,
    910173u32, 912032u32, 912974u32, 913554u32, 914543u32, 916068u32, 916968u32, 919217u32,
    920837u32, 921265u32, 921845u32, 923081u32, 925251u32, 925268u32, 927200u32, 929546u32,
    930273u32, 931162u32, 931623u32, 933761u32, 936118u32, 936865u32, 938822u32, 941159u32,
    943117u32, 945451u32, 947887u32, 950327u32, 952576u32, 954901u32, 957351u32, 957361u32,
    959808u32, 960167u32,
];
pub fn get_feature_stat(name: &str) -> Option<Feature> {
    match KEYS.binary_search(&name) {
        Ok(idx) => {
            let start = RANGES[idx];
            let end = RANGES[idx + 1];
            Some(Feature::new(start, end))
        }
        Err(_) => None,
    }
}
