//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
#[cfg(feature = "objc2-core-graphics")]
#[cfg(target_vendor = "apple")]
use objc2_core_graphics::*;
#[cfg(feature = "objc2-core-image")]
#[cfg(target_vendor = "apple")]
use objc2_core_image::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstiffcompression?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSTIFFCompression(pub NSUInteger);
impl NSTIFFCompression {
    #[doc(alias = "NSTIFFCompressionNone")]
    pub const None: Self = Self(1);
    #[doc(alias = "NSTIFFCompressionCCITTFAX3")]
    pub const CCITTFAX3: Self = Self(3);
    #[doc(alias = "NSTIFFCompressionCCITTFAX4")]
    pub const CCITTFAX4: Self = Self(4);
    #[doc(alias = "NSTIFFCompressionLZW")]
    pub const LZW: Self = Self(5);
    #[doc(alias = "NSTIFFCompressionJPEG")]
    pub const JPEG: Self = Self(6);
    #[doc(alias = "NSTIFFCompressionNEXT")]
    pub const NEXT: Self = Self(32766);
    #[doc(alias = "NSTIFFCompressionPackBits")]
    pub const PackBits: Self = Self(32773);
    #[doc(alias = "NSTIFFCompressionOldJPEG")]
    pub const OldJPEG: Self = Self(32865);
}

unsafe impl Encode for NSTIFFCompression {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSTIFFCompression {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbitmapimagefiletype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSBitmapImageFileType(pub NSUInteger);
impl NSBitmapImageFileType {
    #[doc(alias = "NSBitmapImageFileTypeTIFF")]
    pub const TIFF: Self = Self(0);
    #[doc(alias = "NSBitmapImageFileTypeBMP")]
    pub const BMP: Self = Self(1);
    #[doc(alias = "NSBitmapImageFileTypeGIF")]
    pub const GIF: Self = Self(2);
    #[doc(alias = "NSBitmapImageFileTypeJPEG")]
    pub const JPEG: Self = Self(3);
    #[doc(alias = "NSBitmapImageFileTypePNG")]
    pub const PNG: Self = Self(4);
    #[doc(alias = "NSBitmapImageFileTypeJPEG2000")]
    pub const JPEG2000: Self = Self(5);
}

unsafe impl Encode for NSBitmapImageFileType {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSBitmapImageFileType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagereploadstatus?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSImageRepLoadStatus(pub NSInteger);
impl NSImageRepLoadStatus {
    #[doc(alias = "NSImageRepLoadStatusUnknownType")]
    pub const UnknownType: Self = Self(-1);
    #[doc(alias = "NSImageRepLoadStatusReadingHeader")]
    pub const ReadingHeader: Self = Self(-2);
    #[doc(alias = "NSImageRepLoadStatusWillNeedAllData")]
    pub const WillNeedAllData: Self = Self(-3);
    #[doc(alias = "NSImageRepLoadStatusInvalidData")]
    pub const InvalidData: Self = Self(-4);
    #[doc(alias = "NSImageRepLoadStatusUnexpectedEOF")]
    pub const UnexpectedEOF: Self = Self(-5);
    #[doc(alias = "NSImageRepLoadStatusCompleted")]
    pub const Completed: Self = Self(-6);
}

unsafe impl Encode for NSImageRepLoadStatus {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSImageRepLoadStatus {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbitmapformat?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSBitmapFormat(pub NSUInteger);
bitflags::bitflags! {
    impl NSBitmapFormat: NSUInteger {
        #[doc(alias = "NSBitmapFormatAlphaFirst")]
        const AlphaFirst = 1<<0;
        #[doc(alias = "NSBitmapFormatAlphaNonpremultiplied")]
        const AlphaNonpremultiplied = 1<<1;
        #[doc(alias = "NSBitmapFormatFloatingPointSamples")]
        const FloatingPointSamples = 1<<2;
        #[doc(alias = "NSBitmapFormatSixteenBitLittleEndian")]
        const SixteenBitLittleEndian = 1<<8;
        #[doc(alias = "NSBitmapFormatThirtyTwoBitLittleEndian")]
        const ThirtyTwoBitLittleEndian = 1<<9;
        #[doc(alias = "NSBitmapFormatSixteenBitBigEndian")]
        const SixteenBitBigEndian = 1<<10;
        #[doc(alias = "NSBitmapFormatThirtyTwoBitBigEndian")]
        const ThirtyTwoBitBigEndian = 1<<11;
    }
}

unsafe impl Encode for NSBitmapFormat {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSBitmapFormat {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbitmapimagereppropertykey?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
pub type NSBitmapImageRepPropertyKey = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagecompressionmethod?language=objc)
    pub static NSImageCompressionMethod: &'static NSBitmapImageRepPropertyKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagecompressionfactor?language=objc)
    pub static NSImageCompressionFactor: &'static NSBitmapImageRepPropertyKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagedithertransparency?language=objc)
    pub static NSImageDitherTransparency: &'static NSBitmapImageRepPropertyKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagergbcolortable?language=objc)
    pub static NSImageRGBColorTable: &'static NSBitmapImageRepPropertyKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimageinterlaced?language=objc)
    pub static NSImageInterlaced: &'static NSBitmapImageRepPropertyKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagecolorsyncprofiledata?language=objc)
    pub static NSImageColorSyncProfileData: &'static NSBitmapImageRepPropertyKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimageframecount?language=objc)
    pub static NSImageFrameCount: &'static NSBitmapImageRepPropertyKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagecurrentframe?language=objc)
    pub static NSImageCurrentFrame: &'static NSBitmapImageRepPropertyKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagecurrentframeduration?language=objc)
    pub static NSImageCurrentFrameDuration: &'static NSBitmapImageRepPropertyKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimageloopcount?language=objc)
    pub static NSImageLoopCount: &'static NSBitmapImageRepPropertyKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagegamma?language=objc)
    pub static NSImageGamma: &'static NSBitmapImageRepPropertyKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimageprogressive?language=objc)
    pub static NSImageProgressive: &'static NSBitmapImageRepPropertyKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimageexifdata?language=objc)
    pub static NSImageEXIFData: &'static NSBitmapImageRepPropertyKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimageiptcdata?language=objc)
    pub static NSImageIPTCData: &'static NSBitmapImageRepPropertyKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagefallbackbackgroundcolor?language=objc)
    pub static NSImageFallbackBackgroundColor: &'static NSBitmapImageRepPropertyKey;
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbitmapimagerep?language=objc)
    #[unsafe(super(NSImageRep, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "NSImageRep")]
    pub struct NSBitmapImageRep;
);

#[cfg(feature = "NSImageRep")]
extern_conformance!(
    unsafe impl NSCoding for NSBitmapImageRep {}
);

#[cfg(feature = "NSImageRep")]
extern_conformance!(
    unsafe impl NSCopying for NSBitmapImageRep {}
);

#[cfg(feature = "NSImageRep")]
unsafe impl CopyingHelper for NSBitmapImageRep {
    type Result = Self;
}

#[cfg(feature = "NSImageRep")]
extern_conformance!(
    unsafe impl NSObjectProtocol for NSBitmapImageRep {}
);

#[cfg(feature = "NSImageRep")]
extern_conformance!(
    unsafe impl NSSecureCoding for NSBitmapImageRep {}
);

#[cfg(feature = "NSImageRep")]
impl NSBitmapImageRep {
    extern_methods!(
        #[deprecated = "Use -[NSView cacheDisplayInRect:toBitmapImageRep:] to snapshot a view."]
        #[unsafe(method(initWithFocusedViewRect:))]
        #[unsafe(method_family = init)]
        pub fn initWithFocusedViewRect(
            this: Allocated<Self>,
            rect: NSRect,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSGraphics")]
        /// # Safety
        ///
        /// `planes` must be a valid pointer or null.
        #[unsafe(method(initWithBitmapDataPlanes:pixelsWide:pixelsHigh:bitsPerSample:samplesPerPixel:hasAlpha:isPlanar:colorSpaceName:bytesPerRow:bitsPerPixel:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithBitmapDataPlanes_pixelsWide_pixelsHigh_bitsPerSample_samplesPerPixel_hasAlpha_isPlanar_colorSpaceName_bytesPerRow_bitsPerPixel(
            this: Allocated<Self>,
            planes: *mut *mut c_uchar,
            width: NSInteger,
            height: NSInteger,
            bps: NSInteger,
            spp: NSInteger,
            alpha: bool,
            is_planar: bool,
            color_space_name: &NSColorSpaceName,
            r_bytes: NSInteger,
            p_bits: NSInteger,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSGraphics")]
        /// # Safety
        ///
        /// `planes` must be a valid pointer or null.
        #[unsafe(method(initWithBitmapDataPlanes:pixelsWide:pixelsHigh:bitsPerSample:samplesPerPixel:hasAlpha:isPlanar:colorSpaceName:bitmapFormat:bytesPerRow:bitsPerPixel:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithBitmapDataPlanes_pixelsWide_pixelsHigh_bitsPerSample_samplesPerPixel_hasAlpha_isPlanar_colorSpaceName_bitmapFormat_bytesPerRow_bitsPerPixel(
            this: Allocated<Self>,
            planes: *mut *mut c_uchar,
            width: NSInteger,
            height: NSInteger,
            bps: NSInteger,
            spp: NSInteger,
            alpha: bool,
            is_planar: bool,
            color_space_name: &NSColorSpaceName,
            bitmap_format: NSBitmapFormat,
            r_bytes: NSInteger,
            p_bits: NSInteger,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "objc2-core-graphics")]
        #[cfg(target_vendor = "apple")]
        #[unsafe(method(initWithCGImage:))]
        #[unsafe(method_family = init)]
        pub fn initWithCGImage(this: Allocated<Self>, cg_image: &CGImage) -> Retained<Self>;

        #[cfg(feature = "objc2-core-image")]
        #[cfg(target_vendor = "apple")]
        #[unsafe(method(initWithCIImage:))]
        #[unsafe(method_family = init)]
        pub fn initWithCIImage(this: Allocated<Self>, ci_image: &CIImage) -> Retained<Self>;

        #[unsafe(method(imageRepsWithData:))]
        #[unsafe(method_family = none)]
        pub fn imageRepsWithData(data: &NSData) -> Retained<NSArray<NSImageRep>>;

        #[unsafe(method(imageRepWithData:))]
        #[unsafe(method_family = none)]
        pub fn imageRepWithData(data: &NSData) -> Option<Retained<Self>>;

        #[unsafe(method(initWithData:))]
        #[unsafe(method_family = init)]
        pub fn initWithData(this: Allocated<Self>, data: &NSData) -> Option<Retained<Self>>;

        #[unsafe(method(bitmapData))]
        #[unsafe(method_family = none)]
        pub fn bitmapData(&self) -> *mut c_uchar;

        /// # Safety
        ///
        /// `data` must be a valid pointer.
        #[unsafe(method(getBitmapDataPlanes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getBitmapDataPlanes(&self, data: NonNull<*mut c_uchar>);

        #[unsafe(method(isPlanar))]
        #[unsafe(method_family = none)]
        pub fn isPlanar(&self) -> bool;

        #[unsafe(method(samplesPerPixel))]
        #[unsafe(method_family = none)]
        pub fn samplesPerPixel(&self) -> NSInteger;

        #[unsafe(method(bitsPerPixel))]
        #[unsafe(method_family = none)]
        pub fn bitsPerPixel(&self) -> NSInteger;

        #[unsafe(method(bytesPerRow))]
        #[unsafe(method_family = none)]
        pub fn bytesPerRow(&self) -> NSInteger;

        #[unsafe(method(bytesPerPlane))]
        #[unsafe(method_family = none)]
        pub fn bytesPerPlane(&self) -> NSInteger;

        #[unsafe(method(numberOfPlanes))]
        #[unsafe(method_family = none)]
        pub fn numberOfPlanes(&self) -> NSInteger;

        #[unsafe(method(bitmapFormat))]
        #[unsafe(method_family = none)]
        pub fn bitmapFormat(&self) -> NSBitmapFormat;

        /// # Safety
        ///
        /// - `compression` must be a valid pointer or null.
        /// - `factor` must be a valid pointer or null.
        #[unsafe(method(getCompression:factor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getCompression_factor(
            &self,
            compression: *mut NSTIFFCompression,
            factor: *mut c_float,
        );

        #[unsafe(method(setCompression:factor:))]
        #[unsafe(method_family = none)]
        pub fn setCompression_factor(&self, compression: NSTIFFCompression, factor: c_float);

        #[unsafe(method(TIFFRepresentation))]
        #[unsafe(method_family = none)]
        pub fn TIFFRepresentation(&self) -> Option<Retained<NSData>>;

        #[unsafe(method(TIFFRepresentationUsingCompression:factor:))]
        #[unsafe(method_family = none)]
        pub fn TIFFRepresentationUsingCompression_factor(
            &self,
            comp: NSTIFFCompression,
            factor: c_float,
        ) -> Option<Retained<NSData>>;

        #[unsafe(method(TIFFRepresentationOfImageRepsInArray:))]
        #[unsafe(method_family = none)]
        pub fn TIFFRepresentationOfImageRepsInArray(
            array: &NSArray<NSImageRep>,
        ) -> Option<Retained<NSData>>;

        #[unsafe(method(TIFFRepresentationOfImageRepsInArray:usingCompression:factor:))]
        #[unsafe(method_family = none)]
        pub fn TIFFRepresentationOfImageRepsInArray_usingCompression_factor(
            array: &NSArray<NSImageRep>,
            comp: NSTIFFCompression,
            factor: c_float,
        ) -> Option<Retained<NSData>>;

        /// # Safety
        ///
        /// - `list` must be a valid pointer.
        /// - `num_types` must be a valid pointer.
        #[unsafe(method(getTIFFCompressionTypes:count:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getTIFFCompressionTypes_count(
            list: NonNull<*const NSTIFFCompression>,
            num_types: NonNull<NSInteger>,
        );

        #[unsafe(method(localizedNameForTIFFCompressionType:))]
        #[unsafe(method_family = none)]
        pub fn localizedNameForTIFFCompressionType(
            compression: NSTIFFCompression,
        ) -> Option<Retained<NSString>>;

        #[unsafe(method(canBeCompressedUsing:))]
        #[unsafe(method_family = none)]
        pub fn canBeCompressedUsing(&self, compression: NSTIFFCompression) -> bool;

        #[cfg(all(feature = "NSColor", feature = "objc2-core-foundation"))]
        #[unsafe(method(colorizeByMappingGray:toColor:blackMapping:whiteMapping:))]
        #[unsafe(method_family = none)]
        pub fn colorizeByMappingGray_toColor_blackMapping_whiteMapping(
            &self,
            mid_point: CGFloat,
            mid_point_color: Option<&NSColor>,
            shadow_color: Option<&NSColor>,
            light_color: Option<&NSColor>,
        );

        #[unsafe(method(initForIncrementalLoad))]
        #[unsafe(method_family = init)]
        pub fn initForIncrementalLoad(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(incrementalLoadFromData:complete:))]
        #[unsafe(method_family = none)]
        pub fn incrementalLoadFromData_complete(&self, data: &NSData, complete: bool) -> NSInteger;

        #[cfg(feature = "NSColor")]
        #[unsafe(method(setColor:atX:y:))]
        #[unsafe(method_family = none)]
        pub fn setColor_atX_y(&self, color: &NSColor, x: NSInteger, y: NSInteger);

        #[cfg(feature = "NSColor")]
        #[unsafe(method(colorAtX:y:))]
        #[unsafe(method_family = none)]
        pub fn colorAtX_y(&self, x: NSInteger, y: NSInteger) -> Option<Retained<NSColor>>;

        /// # Safety
        ///
        /// `p` must be a valid pointer.
        #[unsafe(method(getPixel:atX:y:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getPixel_atX_y(&self, p: NonNull<NSUInteger>, x: NSInteger, y: NSInteger);

        /// # Safety
        ///
        /// `p` must be a valid pointer.
        #[unsafe(method(setPixel:atX:y:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPixel_atX_y(&self, p: NonNull<NSUInteger>, x: NSInteger, y: NSInteger);

        #[cfg(feature = "objc2-core-graphics")]
        #[cfg(target_vendor = "apple")]
        #[unsafe(method(CGImage))]
        #[unsafe(method_family = none)]
        pub fn CGImage(&self) -> Option<Retained<CGImage>>;

        #[cfg(feature = "NSColorSpace")]
        #[unsafe(method(colorSpace))]
        #[unsafe(method_family = none)]
        pub fn colorSpace(&self) -> Retained<NSColorSpace>;

        #[cfg(all(feature = "NSColorSpace", feature = "NSGraphics"))]
        #[unsafe(method(bitmapImageRepByConvertingToColorSpace:renderingIntent:))]
        #[unsafe(method_family = none)]
        pub fn bitmapImageRepByConvertingToColorSpace_renderingIntent(
            &self,
            target_space: &NSColorSpace,
            rendering_intent: NSColorRenderingIntent,
        ) -> Option<Retained<NSBitmapImageRep>>;

        #[cfg(feature = "NSColorSpace")]
        #[unsafe(method(bitmapImageRepByRetaggingWithColorSpace:))]
        #[unsafe(method_family = none)]
        pub fn bitmapImageRepByRetaggingWithColorSpace(
            &self,
            new_space: &NSColorSpace,
        ) -> Option<Retained<NSBitmapImageRep>>;
    );
}

/// Methods declared on superclass `NSImageRep`.
#[cfg(feature = "NSImageRep")]
impl NSBitmapImageRep {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "NSImageRep")]
impl NSBitmapImageRep {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

#[cfg(feature = "NSImageRep")]
impl DefaultRetained for NSBitmapImageRep {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

/// NSBitmapImageFileTypeExtensions.
#[cfg(feature = "NSImageRep")]
impl NSBitmapImageRep {
    extern_methods!(
        /// # Safety
        ///
        /// `properties` generic should be of the correct type.
        #[unsafe(method(representationOfImageRepsInArray:usingType:properties:))]
        #[unsafe(method_family = none)]
        pub unsafe fn representationOfImageRepsInArray_usingType_properties(
            image_reps: &NSArray<NSImageRep>,
            storage_type: NSBitmapImageFileType,
            properties: &NSDictionary<NSBitmapImageRepPropertyKey, AnyObject>,
        ) -> Option<Retained<NSData>>;

        /// # Safety
        ///
        /// `properties` generic should be of the correct type.
        #[unsafe(method(representationUsingType:properties:))]
        #[unsafe(method_family = none)]
        pub unsafe fn representationUsingType_properties(
            &self,
            storage_type: NSBitmapImageFileType,
            properties: &NSDictionary<NSBitmapImageRepPropertyKey, AnyObject>,
        ) -> Option<Retained<NSData>>;

        /// # Safety
        ///
        /// `value` should be of the correct type.
        #[unsafe(method(setProperty:withValue:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setProperty_withValue(
            &self,
            property: &NSBitmapImageRepPropertyKey,
            value: Option<&AnyObject>,
        );

        #[unsafe(method(valueForProperty:))]
        #[unsafe(method_family = none)]
        pub fn valueForProperty(
            &self,
            property: &NSBitmapImageRepPropertyKey,
        ) -> Option<Retained<AnyObject>>;
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nstifffiletype?language=objc)
#[deprecated]
pub static NSTIFFFileType: NSBitmapImageFileType =
    NSBitmapImageFileType(NSBitmapImageFileType::TIFF.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbmpfiletype?language=objc)
#[deprecated]
pub static NSBMPFileType: NSBitmapImageFileType =
    NSBitmapImageFileType(NSBitmapImageFileType::BMP.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsgiffiletype?language=objc)
#[deprecated]
pub static NSGIFFileType: NSBitmapImageFileType =
    NSBitmapImageFileType(NSBitmapImageFileType::GIF.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsjpegfiletype?language=objc)
#[deprecated]
pub static NSJPEGFileType: NSBitmapImageFileType =
    NSBitmapImageFileType(NSBitmapImageFileType::JPEG.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nspngfiletype?language=objc)
#[deprecated]
pub static NSPNGFileType: NSBitmapImageFileType =
    NSBitmapImageFileType(NSBitmapImageFileType::PNG.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsjpeg2000filetype?language=objc)
#[deprecated]
pub static NSJPEG2000FileType: NSBitmapImageFileType =
    NSBitmapImageFileType(NSBitmapImageFileType::JPEG2000.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsalphafirstbitmapformat?language=objc)
#[deprecated]
pub static NSAlphaFirstBitmapFormat: NSBitmapFormat = NSBitmapFormat(NSBitmapFormat::AlphaFirst.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsalphanonpremultipliedbitmapformat?language=objc)
#[deprecated]
pub static NSAlphaNonpremultipliedBitmapFormat: NSBitmapFormat =
    NSBitmapFormat(NSBitmapFormat::AlphaNonpremultiplied.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsfloatingpointsamplesbitmapformat?language=objc)
#[deprecated]
pub static NSFloatingPointSamplesBitmapFormat: NSBitmapFormat =
    NSBitmapFormat(NSBitmapFormat::FloatingPointSamples.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/ns16bitlittleendianbitmapformat?language=objc)
#[deprecated]
pub static NS16BitLittleEndianBitmapFormat: NSBitmapFormat =
    NSBitmapFormat(NSBitmapFormat::SixteenBitLittleEndian.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/ns32bitlittleendianbitmapformat?language=objc)
#[deprecated]
pub static NS32BitLittleEndianBitmapFormat: NSBitmapFormat =
    NSBitmapFormat(NSBitmapFormat::ThirtyTwoBitLittleEndian.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/ns16bitbigendianbitmapformat?language=objc)
#[deprecated]
pub static NS16BitBigEndianBitmapFormat: NSBitmapFormat =
    NSBitmapFormat(NSBitmapFormat::SixteenBitBigEndian.0);

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/ns32bitbigendianbitmapformat?language=objc)
#[deprecated]
pub static NS32BitBigEndianBitmapFormat: NSBitmapFormat =
    NSBitmapFormat(NSBitmapFormat::ThirtyTwoBitBigEndian.0);
