package locks

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// Application ...
	Application CreatedByType = "Application"
	// Key ...
	Key CreatedByType = "Key"
	// ManagedIdentity ...
	ManagedIdentity CreatedByType = "ManagedIdentity"
	// User ...
	User CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{Application, Key, ManagedIdentity, User}
}

// LockLevel enumerates the values for lock level.
type LockLevel string

const (
	// CanNotDelete ...
	CanNotDelete LockLevel = "CanNotDelete"
	// NotSpecified ...
	NotSpecified LockLevel = "NotSpecified"
	// ReadOnly ...
	ReadOnly LockLevel = "ReadOnly"
)

// PossibleLockLevelValues returns an array of possible values for the LockLevel const type.
func PossibleLockLevelValues() []LockLevel {
	return []LockLevel{CanNotDelete, NotSpecified, ReadOnly}
}
