package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListApStatus invokes the cloudwf.ListApStatus API synchronously
// api document: https://help.aliyun.com/api/cloudwf/listapstatus.html
func (client *Client) ListApStatus(request *ListApStatusRequest) (response *ListApStatusResponse, err error) {
	response = CreateListApStatusResponse()
	err = client.DoAction(request, response)
	return
}

// ListApStatusWithChan invokes the cloudwf.ListApStatus API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/listapstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListApStatusWithChan(request *ListApStatusRequest) (<-chan *ListApStatusResponse, <-chan error) {
	responseChan := make(chan *ListApStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListApStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListApStatusWithCallback invokes the cloudwf.ListApStatus API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/listapstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListApStatusWithCallback(request *ListApStatusRequest, callback func(response *ListApStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListApStatusResponse
		var err error
		defer close(result)
		response, err = client.ListApStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListApStatusRequest is the request struct for api ListApStatus
type ListApStatusRequest struct {
	*requests.RpcRequest
	OrderCol          string           `position:"Query" name:"OrderCol"`
	SearchName        string           `position:"Query" name:"SearchName"`
	SearchGroupName   string           `position:"Query" name:"SearchGroupName"`
	SearchStatus      requests.Integer `position:"Query" name:"SearchStatus"`
	SearchWanIp       string           `position:"Query" name:"SearchWanIp"`
	SearchApModelName string           `position:"Query" name:"SearchApModelName"`
	Length            requests.Integer `position:"Query" name:"Length"`
	OrderDir          string           `position:"Query" name:"OrderDir"`
	SearchBssEquals   requests.Integer `position:"Query" name:"SearchBssEquals"`
	SearchSwVersion   requests.Integer `position:"Query" name:"SearchSwVersion"`
	SearchCompanyName string           `position:"Query" name:"SearchCompanyName"`
	SearchMac         string           `position:"Query" name:"SearchMac"`
	PageIndex         requests.Integer `position:"Query" name:"PageIndex"`
}

// ListApStatusResponse is the response struct for api ListApStatus
type ListApStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateListApStatusRequest creates a request to invoke ListApStatus API
func CreateListApStatusRequest() (request *ListApStatusRequest) {
	request = &ListApStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ListApStatus", "cloudwf", "openAPI")
	return
}

// CreateListApStatusResponse creates a response to parse from ListApStatus response
func CreateListApStatusResponse() (response *ListApStatusResponse) {
	response = &ListApStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
