/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.object;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.object.AbstractObjectMorpher;
import net.sf.ezmorph.object.BigDecimalMorpher;
import net.sf.ezmorph.object.BigIntegerMorpher;
import net.sf.ezmorph.primitive.ByteMorpher;
import net.sf.ezmorph.primitive.DoubleMorpher;
import net.sf.ezmorph.primitive.FloatMorpher;
import net.sf.ezmorph.primitive.IntMorpher;
import net.sf.ezmorph.primitive.LongMorpher;
import net.sf.ezmorph.primitive.ShortMorpher;

public final class NumberMorpher
extends AbstractObjectMorpher {
    private Number defaultValue;
    private Class type;

    public NumberMorpher(Class type) {
        super(false);
        if (type == null) {
            throw new MorphException("Must specify a type");
        }
        if (!(type == Byte.TYPE || type == Short.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE || Byte.class.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Double.class.isAssignableFrom(type) || BigInteger.class.isAssignableFrom(type) || BigDecimal.class.isAssignableFrom(type))) {
            throw new MorphException("Must specify a Number subclass");
        }
        this.type = type;
    }

    public NumberMorpher(Class type, Number defaultValue) {
        super(true);
        if (type == null) {
            throw new MorphException("Must specify a type");
        }
        if (!(type == Byte.TYPE || type == Short.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE || Byte.class.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Double.class.isAssignableFrom(type) || BigInteger.class.isAssignableFrom(type) || BigDecimal.class.isAssignableFrom(type))) {
            throw new MorphException("Must specify a Number subclass");
        }
        if (defaultValue != null && !type.isInstance(defaultValue)) {
            throw new MorphException("Default value must be of type " + String.valueOf(type));
        }
        this.type = type;
        this.setDefaultValue(defaultValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumberMorpher)) {
            return false;
        }
        NumberMorpher other = (NumberMorpher)obj;
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        if (this.isUseDefault() && other.isUseDefault()) {
            return Objects.equals(this.getDefaultValue(), other.getDefaultValue());
        }
        return !this.isUseDefault() && !other.isUseDefault();
    }

    public Number getDefaultValue() {
        return this.defaultValue;
    }

    public int hashCode() {
        int result = Objects.hashCode(this.type);
        if (this.isUseDefault()) {
            result = 31 * result + Objects.hashCode(this.getDefaultValue());
        }
        return result;
    }

    @Override
    public Object morph(Object value) {
        if (value != null && this.type.isAssignableFrom(value.getClass())) {
            return value;
        }
        String str = String.valueOf(value).trim();
        if (!this.type.isPrimitive() && (value == null || str.length() == 0 || "null".equalsIgnoreCase(str))) {
            return null;
        }
        if (this.isDecimalNumber(this.type)) {
            if (Float.class.isAssignableFrom(this.type) || Float.TYPE == this.type) {
                return this.morphToFloat(str);
            }
            if (Double.class.isAssignableFrom(this.type) || Double.TYPE == this.type) {
                return this.morphToDouble(str);
            }
            return this.morphToBigDecimal(str);
        }
        if (Byte.class.isAssignableFrom(this.type) || Byte.TYPE == this.type) {
            return this.morphToByte(str);
        }
        if (Short.class.isAssignableFrom(this.type) || Short.TYPE == this.type) {
            return this.morphToShort(str);
        }
        if (Integer.class.isAssignableFrom(this.type) || Integer.TYPE == this.type) {
            return this.morphToInteger(str);
        }
        if (Long.class.isAssignableFrom(this.type) || Long.TYPE == this.type) {
            return this.morphToLong(str);
        }
        return this.morphToBigInteger(str);
    }

    @Override
    public Class morphsTo() {
        return this.type;
    }

    public void setDefaultValue(Number defaultValue) {
        if (defaultValue != null && !this.type.isInstance(defaultValue)) {
            throw new MorphException("Default value must be of type " + String.valueOf(this.type));
        }
        this.defaultValue = defaultValue;
    }

    private boolean isDecimalNumber(Class type) {
        return Double.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Double.TYPE == type || Float.TYPE == type || BigDecimal.class.isAssignableFrom(type);
    }

    private Object morphToBigDecimal(String str) {
        Object result = null;
        result = this.isUseDefault() ? new BigDecimalMorpher((BigDecimal)this.defaultValue).morph(str) : new BigDecimal(str);
        return result;
    }

    private Object morphToBigInteger(String str) {
        Object result = null;
        result = this.isUseDefault() ? new BigIntegerMorpher((BigInteger)this.defaultValue).morph(str) : new BigInteger(str);
        return result;
    }

    private Object morphToByte(String str) {
        byte result;
        if (this.isUseDefault()) {
            if (this.defaultValue == null) {
                return null;
            }
            result = new ByteMorpher(this.defaultValue.byteValue()).morph(str);
        } else {
            result = new ByteMorpher().morph(str);
        }
        return result;
    }

    private Double morphToDouble(String str) {
        double result;
        if (this.isUseDefault()) {
            if (this.defaultValue == null) {
                return null;
            }
            result = new DoubleMorpher(this.defaultValue.doubleValue()).morph(str);
        } else {
            result = new DoubleMorpher().morph(str);
        }
        return result;
    }

    private Object morphToFloat(String str) {
        float result;
        if (this.isUseDefault()) {
            if (this.defaultValue == null) {
                return null;
            }
            result = new FloatMorpher(this.defaultValue.floatValue()).morph(str);
        } else {
            result = new FloatMorpher().morph(str);
        }
        return Float.valueOf(result);
    }

    private Integer morphToInteger(String str) {
        int result;
        if (this.isUseDefault()) {
            if (this.defaultValue == null) {
                return null;
            }
            result = new IntMorpher(this.defaultValue.intValue()).morph(str);
        } else {
            result = new IntMorpher().morph(str);
        }
        return result;
    }

    private Long morphToLong(String str) {
        long result;
        if (this.isUseDefault()) {
            if (this.defaultValue == null) {
                return null;
            }
            result = new LongMorpher(this.defaultValue.longValue()).morph(str);
        } else {
            result = new LongMorpher().morph(str);
        }
        return result;
    }

    private Object morphToShort(String str) {
        short result;
        if (this.isUseDefault()) {
            if (this.defaultValue == null) {
                return null;
            }
            result = new ShortMorpher(this.defaultValue.shortValue()).morph(str);
        } else {
            result = new ShortMorpher().morph(str);
        }
        return result;
    }
}

