/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.util;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public final class DurationFormatter {
    private DurationFormatter() {
    }

    public static String format(Duration d) {
        long seconds;
        long minutes;
        long hours;
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        long days = d.toDays();
        if (days > 0L) {
            first = DurationFormatter.formatDurationPart(true, sb, days, "day");
            d = d.minus(days, ChronoUnit.DAYS);
        }
        if ((hours = d.toHours()) > 0L) {
            first = DurationFormatter.formatDurationPart(first, sb, hours, "hour");
            d = d.minus(hours, ChronoUnit.HOURS);
        }
        if ((minutes = d.toMinutes()) > 0L) {
            first = DurationFormatter.formatDurationPart(first, sb, minutes, "minute");
            d = d.minus(minutes, ChronoUnit.MINUTES);
        }
        if ((seconds = d.getSeconds()) > 0L) {
            DurationFormatter.formatDurationPart(first, sb, seconds, "second");
        }
        return sb.toString();
    }

    private static boolean formatDurationPart(boolean first, StringBuilder sb, long amount, String unit) {
        if (!first) {
            sb.append(", ");
        } else {
            first = false;
        }
        sb.append(amount).append(" ").append(unit).append(amount > 1L ? "s" : "");
        return first;
    }
}

