/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model.queue;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Action;
import hudson.model.Queue;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.accmod.restrictions.DoNotUse;

@Restricted(value={Beta.class})
public abstract class QueueIdStrategy
implements ExtensionPoint {
    private static final QueueIdStrategy DEFAULT = new DefaultStrategy();

    public static QueueIdStrategy get() {
        ExtensionList<QueueIdStrategy> strategies = ExtensionList.lookup(QueueIdStrategy.class);
        if (strategies.isEmpty()) {
            return DEFAULT;
        }
        return strategies.get(0);
    }

    public void persist(@NonNull Queue.State queueState) {
    }

    public void load(@NonNull Queue.State queueState) {
    }

    public abstract long generateIdFor(@NonNull Queue.Task var1, @NonNull List<Action> var2);

    public static final class DefaultStrategy
    extends QueueIdStrategy {
        private static final AtomicLong COUNTER = new AtomicLong(0L);

        @Override
        public long generateIdFor(Queue.Task project, List<Action> actions) {
            return COUNTER.incrementAndGet();
        }

        @Override
        public void persist(Queue.State queueState) {
            queueState.properties.put(this.getClass().getName(), COUNTER.get());
        }

        @Override
        public void load(Queue.State queueState) {
            Object prop = queueState.properties.get(this.getClass().getName());
            if (prop instanceof Long) {
                COUNTER.set((Long)prop);
            } else {
                queueState.items.stream().filter(Queue.Item.class::isInstance).map(Queue.Item.class::cast).max(Comparator.comparing(Queue.Item::getId)).ifPresentOrElse(maxItem -> COUNTER.set(maxItem.getId()), () -> COUNTER.set(0L));
            }
        }

        @Restricted(value={DoNotUse.class})
        public static long getCurrentCounterValue() {
            return COUNTER.get();
        }
    }
}

