/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model.details;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Actionable;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.details.Detail;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class DetailFactory<T extends Actionable>
implements ExtensionPoint {
    public abstract Class<T> type();

    @NonNull
    public abstract List<? extends Detail> createFor(@NonNull T var1);

    @Restricted(value={NoExternalUse.class})
    public static <T extends Actionable> List<DetailFactory<T>> factoriesFor(Class<T> type) {
        ArrayList<DetailFactory<T>> result = new ArrayList<DetailFactory<T>>();
        for (DetailFactory wf : ExtensionList.lookup(DetailFactory.class)) {
            if (!wf.type().isAssignableFrom(type)) continue;
            result.add(wf);
        }
        return result;
    }
}

