/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Util;
import hudson.model.Queue;
import hudson.model.queue.WorkUnit;
import jenkins.model.IComputer;
import jenkins.model.queue.ITask;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

@Restricted(value={Beta.class})
public interface IExecutor {
    public boolean isIdle();

    public IComputer getOwner();

    @CheckForNull
    public Queue.Executable getCurrentExecutable();

    @CheckForNull
    public WorkUnit getCurrentWorkUnit();

    public String getDisplayName();

    @CheckForNull
    default public ITask getParentTask() {
        Queue.Executable currentExecutable = this.getCurrentExecutable();
        if (currentExecutable == null) {
            WorkUnit workUnit = this.getCurrentWorkUnit();
            if (workUnit != null) {
                return workUnit.work;
            }
            return null;
        }
        return currentExecutable.getParent();
    }

    public boolean hasStopPermission();

    public int getNumber();

    public long getElapsedTime();

    default public String getTimestampString() {
        return Util.getTimeSpanString(this.getElapsedTime());
    }

    public String getEstimatedRemainingTime();

    public boolean isLikelyStuck();

    public int getProgress();
}

