/*
 * Decompiled with CFR 0.152.
 */
package jenkins.fingerprints;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.ExtensionList;
import java.util.logging.Logger;
import jenkins.fingerprints.FileFingerprintStorage;
import jenkins.fingerprints.FingerprintStorage;
import jenkins.fingerprints.FingerprintStorageDescriptor;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
@Symbol(value={"fingerprints"})
public class GlobalFingerprintConfiguration
extends GlobalConfiguration {
    private FingerprintStorage storage = ExtensionList.lookupSingleton(FileFingerprintStorage.class);
    private static final Logger LOGGER = Logger.getLogger(GlobalFingerprintConfiguration.class.getName());
    private boolean fingerprintCleanupDisabled;

    public GlobalFingerprintConfiguration() {
        this.load();
    }

    public static GlobalFingerprintConfiguration get() {
        return ExtensionList.lookupSingleton(GlobalFingerprintConfiguration.class);
    }

    public FingerprintStorage getStorage() {
        return this.storage;
    }

    @DataBoundSetter
    public void setStorage(FingerprintStorage fingerprintStorage) {
        this.storage = fingerprintStorage;
        LOGGER.fine("Fingerprint Storage for the system changed to " + fingerprintStorage.getDescriptor().getDisplayName());
    }

    public boolean isFingerprintCleanupDisabled() {
        return this.fingerprintCleanupDisabled;
    }

    @DataBoundSetter
    public void setFingerprintCleanupDisabled(boolean fingerprintCleanupDisabled) {
        this.fingerprintCleanupDisabled = fingerprintCleanupDisabled;
    }

    @Override
    public boolean configure(StaplerRequest2 req, JSONObject json) {
        req.bindJSON((Object)this, json);
        this.save();
        return true;
    }

    public DescriptorExtensionList<FingerprintStorage, FingerprintStorageDescriptor> getFingerprintStorageDescriptors() {
        return FingerprintStorageDescriptor.all();
    }
}

