/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import hudson.util.DelegatingClassLoader;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class CachingClassLoader
extends DelegatingClassLoader {
    private final ConcurrentHashMap<String, Object> cache = new ConcurrentHashMap();

    public CachingClassLoader(String name, ClassLoader parent) {
        super(name, parent);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object classOrEmpty = this.cache.computeIfAbsent(name, key -> {
            try {
                return super.loadClass(name, false);
            }
            catch (ClassNotFoundException e) {
                return Optional.empty();
            }
        });
        if (classOrEmpty == Optional.empty()) {
            throw new ClassNotFoundException(name);
        }
        Class clazz = (Class)classOrEmpty;
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public void clearCacheMisses() {
        this.cache.values().removeIf(v -> v == Optional.empty());
    }
}

