/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.User;
import hudson.model.View;
import hudson.security.ACL;
import hudson.security.Messages;
import hudson.security.Permission;
import hudson.slaves.Cloud;
import hudson.util.DescriptorList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import jenkins.model.IComputer;
import jenkins.model.Jenkins;
import jenkins.security.stapler.StaplerAccessibleType;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.StaplerRequest2;
import org.springframework.security.core.Authentication;

@StaplerAccessibleType
public abstract class AuthorizationStrategy
implements Describable<AuthorizationStrategy>,
ExtensionPoint {
    @Deprecated
    public static final DescriptorList<AuthorizationStrategy> LIST = new DescriptorList<AuthorizationStrategy>(AuthorizationStrategy.class);
    public static final AuthorizationStrategy UNSECURED = new Unsecured();

    @NonNull
    public abstract ACL getRootACL();

    @Deprecated
    @NonNull
    public ACL getACL(@NonNull AbstractProject<?, ?> project) {
        return this.getACL((Job<?, ?>)project);
    }

    @NonNull
    public ACL getACL(@NonNull Job<?, ?> project) {
        return this.getRootACL();
    }

    @NonNull
    public ACL getACL(@NonNull View item) {
        return ACL.lambda2((a, permission) -> {
            ACL base = item.getOwner().getACL();
            boolean hasPermission = base.hasPermission2((Authentication)a, (Permission)permission);
            if (!hasPermission && permission == View.READ) {
                return base.hasPermission2((Authentication)a, View.CONFIGURE) || !item.getItems().isEmpty();
            }
            return hasPermission;
        });
    }

    @NonNull
    public ACL getACL(@NonNull AbstractItem item) {
        return this.getRootACL();
    }

    @NonNull
    public ACL getACL(@NonNull User user) {
        return this.getRootACL();
    }

    @NonNull
    public ACL getACL(@NonNull Computer computer) {
        return this.getACL(computer.getNode());
    }

    @NonNull
    public ACL getACL(@NonNull IComputer computer) {
        if (computer instanceof Computer) {
            Computer c = (Computer)computer;
            return this.getACL(c);
        }
        return this.getRootACL();
    }

    @NonNull
    public ACL getACL(@NonNull Cloud cloud) {
        return this.getRootACL();
    }

    @NonNull
    public ACL getACL(@NonNull Node node) {
        return this.getRootACL();
    }

    @NonNull
    public abstract Collection<String> getGroups();

    @NonNull
    public static DescriptorExtensionList<AuthorizationStrategy, Descriptor<AuthorizationStrategy>> all() {
        return Jenkins.get().getDescriptorList(AuthorizationStrategy.class);
    }

    public static final class Unsecured
    extends AuthorizationStrategy
    implements Serializable {
        private static final ACL UNSECURED_ACL = ACL.lambda2((a, p) -> true);

        private Object readResolve() {
            return UNSECURED;
        }

        @Override
        @NonNull
        public ACL getRootACL() {
            return UNSECURED_ACL;
        }

        @Override
        @NonNull
        public Collection<String> getGroups() {
            return Collections.emptySet();
        }

        @Extension
        @Symbol(value={"unsecured"})
        public static final class DescriptorImpl
        extends Descriptor<AuthorizationStrategy> {
            @Override
            @NonNull
            public String getDisplayName() {
                return Messages.AuthorizationStrategy_DisplayName();
            }

            @Override
            @NonNull
            public AuthorizationStrategy newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
                return UNSECURED;
            }
        }
    }
}

