/*
 * Decompiled with CFR 0.152.
 */
package hudson.node_monitors;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Computer;
import hudson.node_monitors.AbstractAsyncNodeMonitorDescriptor;
import hudson.node_monitors.AbstractNodeMonitorDescriptor;
import hudson.node_monitors.Messages;
import hudson.node_monitors.MonitorOfflineCause;
import hudson.node_monitors.NodeMonitor;
import hudson.remoting.Callable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

public class ResponseTimeMonitor
extends NodeMonitor {
    @SuppressFBWarnings(value={"MS_PKGPROTECT"}, justification="for backward compatibility")
    public static AbstractNodeMonitorDescriptor<Data> DESCRIPTOR;
    private static final long TIMEOUT = 5000L;
    private static final Logger LOGGER;

    @DataBoundConstructor
    public ResponseTimeMonitor() {
    }

    static {
        LOGGER = Logger.getLogger(ResponseTimeMonitor.class.getName());
    }

    @ExportedBean
    public static final class Data
    extends MonitorOfflineCause
    implements Serializable {
        private final long[] past5;
        private static final long serialVersionUID = 1L;

        private Data(Data old, long newDataPoint) {
            if (old == null) {
                this.past5 = new long[]{newDataPoint};
            } else {
                this.past5 = new long[Math.min(5, old.past5.length + 1)];
                int copyLen = this.past5.length - 1;
                System.arraycopy(old.past5, old.past5.length - copyLen, this.past5, 0, copyLen);
                this.past5[this.past5.length - 1] = newDataPoint;
            }
        }

        private int failureCount() {
            int cnt = 0;
            int i = this.past5.length - 1;
            while (i >= 0 && this.past5[i] < 0L) {
                --i;
                ++cnt;
            }
            return cnt;
        }

        @Exported
        public long getAverage() {
            long total = 0L;
            for (long l : this.past5) {
                if (l < 0L) {
                    total += 5000L;
                    continue;
                }
                total += l;
            }
            return total / (long)this.past5.length;
        }

        public boolean hasTooManyTimeouts() {
            return this.failureCount() >= 5;
        }

        public String toString() {
            int fc = this.failureCount();
            if (fc > 0) {
                return Messages.ResponseTimeMonitor_TimeOut(fc);
            }
            return this.getAverage() + "ms";
        }

        @Override
        public Class<? extends NodeMonitor> getTrigger() {
            return ResponseTimeMonitor.class;
        }
    }

    private static final class Step3
    implements Serializable {
        private final Data cur;
        private final long start;
        private static final long serialVersionUID = 1L;

        private Step3(Data cur, long start) {
            this.cur = cur;
            this.start = start;
        }

        private Object readResolve() {
            long end = System.currentTimeMillis();
            return new Data(this.cur, end - this.start);
        }
    }

    private static final class Step2
    extends MasterToSlaveCallable<Step3, IOException> {
        private final Data cur;
        private final long start = System.currentTimeMillis();
        private static final long serialVersionUID = 1L;

        Step2(Data cur) {
            this.cur = cur;
        }

        @Override
        public Step3 call() {
            return new Step3(this.cur, this.start);
        }
    }

    private static final class Step1
    extends MasterToSlaveCallable<Data, IOException> {
        private Data cur;
        private static final long serialVersionUID = 1L;

        private Step1(Data cur) {
            this.cur = cur;
        }

        @Override
        public Data call() {
            return new Data(this.cur, 0L);
        }

        private Object writeReplace() {
            return new Step2(this.cur);
        }
    }

    @Extension
    @Symbol(value={"responseTime"})
    public static class DescriptorImpl
    extends AbstractAsyncNodeMonitorDescriptor<Data> {
        @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="for backward compatibility")
        public DescriptorImpl() {
            DESCRIPTOR = this;
        }

        @Override
        protected Callable<Data, IOException> createCallable(Computer c) {
            return new Step1((Data)this.get(c));
        }

        @Override
        protected Map<Computer, Data> monitor() throws InterruptedException {
            AbstractAsyncNodeMonitorDescriptor.Result base = this.monitorDetailed();
            Map<Computer, Data> monitoringData = base.getMonitoringData();
            for (Map.Entry e : monitoringData.entrySet()) {
                Computer c = e.getKey();
                Data d = (Data)e.getValue();
                if (base.getSkipped().contains(c)) {
                    assert (d == null);
                    continue;
                }
                if (d == null) {
                    d = new Data((Data)this.get(c), -1L);
                    e.setValue(d);
                }
                if (!d.hasTooManyTimeouts() || this.isIgnored()) continue;
                c.disconnect(d);
                LOGGER.warning(Messages.ResponseTimeMonitor_MarkedOffline(c.getName()));
            }
            return monitoringData;
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.ResponseTimeMonitor_DisplayName();
        }
    }
}

