/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import hudson.Extension;
import hudson.Util;
import hudson.diagnosis.OldDataMonitor;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Messages;
import hudson.model.Saveable;
import hudson.model.listeners.ItemListener;
import hudson.util.Secret;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.StaplerResponse2;
import org.springframework.security.access.AccessDeniedException;

@Deprecated
public final class BuildAuthorizationToken {
    private final Secret token;
    private transient boolean fromPlaintext;

    @Deprecated
    public BuildAuthorizationToken(String token) {
        this.token = Secret.fromString(token);
        this.fromPlaintext = true;
    }

    public BuildAuthorizationToken(Secret token) {
        this.token = token;
        this.fromPlaintext = false;
    }

    public static BuildAuthorizationToken create(StaplerRequest2 req) {
        String token;
        if (req.getParameter("pseudoRemoteTrigger") != null && (token = Util.fixEmpty(req.getParameter("authToken"))) != null) {
            return new BuildAuthorizationToken(token);
        }
        return null;
    }

    @Deprecated
    public static BuildAuthorizationToken create(StaplerRequest req) {
        return BuildAuthorizationToken.create(StaplerRequest.toStaplerRequest2((StaplerRequest)req));
    }

    @Deprecated
    public static void checkPermission(AbstractProject<?, ?> project, BuildAuthorizationToken token, StaplerRequest req, StaplerResponse rsp) throws IOException {
        BuildAuthorizationToken.checkPermission(project, token, StaplerRequest.toStaplerRequest2((StaplerRequest)req), StaplerResponse.toStaplerResponse2((StaplerResponse)rsp));
    }

    public static void checkPermission(Job<?, ?> project, BuildAuthorizationToken token, StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        if (token != null && token.token != null) {
            String providedToken = req.getParameter("token");
            if (providedToken != null && MessageDigest.isEqual(providedToken.getBytes(StandardCharsets.UTF_8), token.getToken().getBytes(StandardCharsets.UTF_8))) {
                return;
            }
            if (providedToken != null) {
                throw new AccessDeniedException(Messages.BuildAuthorizationToken_InvalidTokenProvided());
            }
        }
        project.checkPermission(Item.BUILD);
        if (req.getMethod().equals("POST")) {
            return;
        }
        rsp.setStatus(405);
        rsp.addHeader("Allow", "POST");
        throw HttpResponses.forwardToView(project, (String)"requirePOST.jelly");
    }

    @Deprecated
    public static void checkPermission(Job<?, ?> project, BuildAuthorizationToken token, StaplerRequest req, StaplerResponse rsp) throws IOException {
        BuildAuthorizationToken.checkPermission(project, token, StaplerRequest.toStaplerRequest2((StaplerRequest)req), StaplerResponse.toStaplerResponse2((StaplerResponse)rsp));
    }

    @Deprecated
    public String getToken() {
        return this.token.getPlainText();
    }

    public Secret getEncryptedToken() {
        return this.token;
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static class ItemListenerImpl
    extends ItemListener {
        private static final Logger LOGGER = Logger.getLogger(ItemListenerImpl.class.getName());

        @Override
        public void onUpdated(Item item) {
            ParameterizedJobMixIn.ParameterizedJob job;
            BuildAuthorizationToken bat;
            if (item instanceof ParameterizedJobMixIn.ParameterizedJob && (bat = (job = (ParameterizedJobMixIn.ParameterizedJob)item).getAuthToken()) != null) {
                if (bat.fromPlaintext) {
                    OldDataMonitor.report((Saveable)item, "2.528.3");
                    LOGGER.log(Level.FINE, "Reporting " + item.getFullName());
                } else {
                    LOGGER.log(Level.FINE, "Skipping reporting of " + item.getFullName());
                }
            }
        }

        @Override
        public void onLoaded() {
            Jenkins.get().getAllItems(ParameterizedJobMixIn.ParameterizedJob.class).forEach(this::onUpdated);
        }
    }

    public static final class ConverterImpl
    extends AbstractSingleValueConverter {
        public boolean canConvert(Class type) {
            return type == BuildAuthorizationToken.class;
        }

        public Object fromString(String str) {
            if (Secret.decrypt(str) == null) {
                return new BuildAuthorizationToken(str);
            }
            return new BuildAuthorizationToken(Secret.fromString(str));
        }

        public String toString(Object obj) {
            BuildAuthorizationToken bat = (BuildAuthorizationToken)obj;
            bat.fromPlaintext = false;
            return bat.token.getEncryptedValue();
        }
    }
}

