/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jsr269;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.FileObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.jsr269.AbstractProcessorImpl;

@SupportedAnnotationTypes(value={"org.kohsuke.stapler.QueryParameter"})
public class QueryParameterAnnotationProcessor
extends AbstractProcessorImpl {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            Set<? extends Element> params = roundEnv.getElementsAnnotatedWith(QueryParameter.class);
            HashSet<ExecutableElement> methods = new HashSet<ExecutableElement>();
            for (Element element : params) {
                if (element.getAnnotation(QueryParameter.class) == null) continue;
                methods.add((ExecutableElement)element.getEnclosingElement());
            }
            HashMap<String, String> output = new HashMap<String, String>();
            for (ExecutableElement m : methods) {
                String paramNames = m.getParameters().stream().map(VariableElement::getSimpleName).collect(Collectors.joining(","));
                String existing = (String)output.get(m.getSimpleName().toString());
                if (existing != null && existing.equals(paramNames)) continue;
                this.write(paramNames, m);
                output.put(m.getSimpleName().toString(), paramNames);
            }
        }
        catch (IOException e) {
            this.error(e);
        }
        catch (Error | RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private void write(String paramNames, ExecutableElement m) throws IOException {
        TypeElement t = (TypeElement)m.getEnclosingElement();
        String name = t.getQualifiedName().toString().replace('.', '/') + "/" + String.valueOf(m.getSimpleName()) + ".stapler";
        FileObject f = this.createResource(name);
        this.notice("Generating " + name, m);
        try (OutputStream os = f.openOutputStream();){
            os.write(paramNames.getBytes(StandardCharsets.UTF_8));
        }
    }
}

