/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.json;

import jakarta.servlet.ServletException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.Interceptor;
import org.kohsuke.stapler.interceptor.InterceptorAnnotation;
import org.kohsuke.stapler.json.JsonHttpResponse;

@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@InterceptorAnnotation(value=Handler.class)
public @interface JsonResponse {

    public static class Handler
    extends Interceptor {
        private static final Logger logger = Logger.getLogger(Handler.class.getName());

        @Override
        public Object invoke(StaplerRequest2 request, StaplerResponse2 response, Object instance, Object[] arguments) throws IllegalAccessException, InvocationTargetException, ServletException {
            try {
                Object r = this.target.invoke(request, response, instance, arguments);
                JSONObject j = r == null ? null : (r instanceof JSONObject ? (JSONObject)r : JSONObject.fromObject((Object)r));
                return new JsonHttpResponse(j);
            }
            catch (InvocationTargetException e) {
                logger.log(Level.SEVERE, "Error processing request", e);
                Throwable target = e.getTargetException();
                if (target instanceof HttpResponse) {
                    return target;
                }
                return new JsonHttpResponse(target, 500);
            }
        }
    }
}

