/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model.identity;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import jenkins.model.identity.InstanceIdentityProvider;
import org.jenkinsci.remoting.util.KeyUtils;

@Extension
public class IdentityRootAction
implements UnprotectedRootAction {
    @Override
    public String getIconFileName() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return null;
    }

    @Override
    public String getUrlName() {
        return InstanceIdentityProvider.RSA.getKeyPair() == null ? null : "instance-identity";
    }

    @CheckForNull
    public String getPublicKey() {
        int len;
        RSAPublicKey key = InstanceIdentityProvider.RSA.getPublicKey();
        if (key == null) {
            return null;
        }
        byte[] encoded = Base64.getEncoder().encode(key.getEncoded());
        StringBuilder buf = new StringBuilder(encoded.length + 20);
        for (int index = 0; index < encoded.length; index += len) {
            len = Math.min(64, encoded.length - index);
            if (index > 0) {
                buf.append("\n");
            }
            buf.append(new String(encoded, index, len, StandardCharsets.UTF_8));
        }
        return String.format("-----BEGIN PUBLIC KEY-----%n%s%n-----END PUBLIC KEY-----%n", buf);
    }

    @NonNull
    public String getFingerprint() {
        return KeyUtils.fingerprint(InstanceIdentityProvider.RSA.getPublicKey());
    }
}

