/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.List;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPosition;
import org.jfree.chart.axis.CategoryTick;
import org.jfree.chart.entity.CategoryLabelEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.text.TextBlock;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;

public class NoOverlapCategoryAxis
extends CategoryAxis {
    public NoOverlapCategoryAxis(String label) {
        super(label);
    }

    protected AxisState drawCategoryLabels(Graphics2D g2, Rectangle2D plotArea, Rectangle2D dataArea, RectangleEdge edge, AxisState state, PlotRenderingInfo plotState) {
        if (state == null) {
            throw new IllegalArgumentException("Null 'state' argument.");
        }
        if (this.isTickLabelsVisible()) {
            List ticks = this.refreshTicks(g2, state, plotArea, edge);
            state.setTicks(ticks);
            RectangularShape r = null;
            int categoryIndex = 0;
            for (Object tick1 : ticks) {
                CategoryTick tick = (CategoryTick)tick1;
                g2.setFont(this.getTickLabelFont(tick.getCategory()));
                g2.setPaint(this.getTickLabelPaint(tick.getCategory()));
                CategoryLabelPosition position = this.getCategoryLabelPositions().getLabelPosition(edge);
                double x0 = 0.0;
                double x1 = 0.0;
                double y0 = 0.0;
                double y1 = 0.0;
                if (edge == RectangleEdge.TOP) {
                    x0 = this.getCategoryStart(categoryIndex, ticks.size(), dataArea, edge);
                    x1 = this.getCategoryEnd(categoryIndex, ticks.size(), dataArea, edge);
                    y1 = state.getCursor() - (double)this.getCategoryLabelPositionOffset();
                    y0 = y1 - state.getMax();
                } else if (edge == RectangleEdge.BOTTOM) {
                    x0 = this.getCategoryStart(categoryIndex, ticks.size(), dataArea, edge);
                    x1 = this.getCategoryEnd(categoryIndex, ticks.size(), dataArea, edge);
                    y0 = state.getCursor() + (double)this.getCategoryLabelPositionOffset();
                    y1 = y0 + state.getMax();
                } else if (edge == RectangleEdge.LEFT) {
                    y0 = this.getCategoryStart(categoryIndex, ticks.size(), dataArea, edge);
                    y1 = this.getCategoryEnd(categoryIndex, ticks.size(), dataArea, edge);
                    x1 = state.getCursor() - (double)this.getCategoryLabelPositionOffset();
                    x0 = x1 - state.getMax();
                } else if (edge == RectangleEdge.RIGHT) {
                    y0 = this.getCategoryStart(categoryIndex, ticks.size(), dataArea, edge);
                    y1 = this.getCategoryEnd(categoryIndex, ticks.size(), dataArea, edge);
                    x0 = state.getCursor() + (double)this.getCategoryLabelPositionOffset();
                    x1 = x0 - state.getMax();
                }
                Rectangle2D.Double area = new Rectangle2D.Double(x0, y0, x1 - x0, y1 - y0);
                if (r == null || !r.intersects(area)) {
                    EntityCollection entities;
                    Point2D anchorPoint = RectangleAnchor.coordinates((Rectangle2D)area, (RectangleAnchor)position.getCategoryAnchor());
                    TextBlock block = tick.getLabel();
                    block.draw(g2, (float)anchorPoint.getX(), (float)anchorPoint.getY(), position.getLabelAnchor(), (float)anchorPoint.getX(), (float)anchorPoint.getY(), position.getAngle());
                    Shape bounds = block.calculateBounds(g2, (float)anchorPoint.getX(), (float)anchorPoint.getY(), position.getLabelAnchor(), (float)anchorPoint.getX(), (float)anchorPoint.getY(), position.getAngle());
                    if (plotState != null && plotState.getOwner() != null && (entities = plotState.getOwner().getEntityCollection()) != null) {
                        String tooltip = this.getCategoryLabelToolTip(tick.getCategory());
                        entities.add((ChartEntity)new CategoryLabelEntity(tick.getCategory(), bounds, tooltip, null));
                    }
                    r = bounds.getBounds2D();
                    ((Rectangle2D)r).add(r.getMaxX() + r.getWidth() / 2.0, r.getCenterY());
                    ((Rectangle2D)r).add(r.getMinX() - r.getWidth() / 2.0, r.getCenterY());
                    ((Rectangle2D)r).add(r.getCenterX(), r.getMinY() - r.getHeight() / 2.0);
                    ((Rectangle2D)r).add(r.getCenterX(), r.getMaxX() + r.getHeight() / 2.0);
                }
                ++categoryIndex;
            }
            if (edge.equals((Object)RectangleEdge.TOP)) {
                double h = state.getMax();
                state.cursorUp(h);
            } else if (edge.equals((Object)RectangleEdge.BOTTOM)) {
                double h = state.getMax();
                state.cursorDown(h);
            } else if (edge == RectangleEdge.LEFT) {
                double w = state.getMax();
                state.cursorLeft(w);
            } else if (edge == RectangleEdge.RIGHT) {
                double w = state.getMax();
                state.cursorRight(w);
            }
        }
        return state;
    }
}

