/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Functions;
import hudson.util.DaemonThreadFactory;
import hudson.util.FileChannelWriter;
import hudson.util.NamingThreadFactory;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.ref.Cleaner;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.SystemProperties;

public class AtomicFileWriter
extends Writer {
    private static final Logger LOGGER = Logger.getLogger(AtomicFileWriter.class.getName());
    private static final Cleaner CLEANER = Cleaner.create(new NamingThreadFactory(new DaemonThreadFactory(), AtomicFileWriter.class.getName() + ".cleaner"));
    private static boolean DISABLE_FORCED_FLUSH = SystemProperties.getBoolean(AtomicFileWriter.class.getName() + ".DISABLE_FORCED_FLUSH");
    private static boolean REQUIRES_DIR_FSYNC = SystemProperties.getBoolean(AtomicFileWriter.class.getName() + ".REQUIRES_DIR_FSYNC", !Functions.isWindows());
    private static boolean atomicMoveSupported = true;
    private final FileChannelWriter core;
    private final Path tmpPath;
    private final Path destPath;

    public AtomicFileWriter(File f) throws IOException {
        this(AtomicFileWriter.toPath(f), StandardCharsets.UTF_8);
    }

    @Deprecated
    public AtomicFileWriter(@NonNull File f, @Nullable String encoding) throws IOException {
        this(AtomicFileWriter.toPath(f), encoding == null ? Charset.defaultCharset() : Charset.forName(encoding));
    }

    private static Path toPath(@NonNull File file) throws IOException {
        try {
            return file.toPath();
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
    }

    public AtomicFileWriter(@NonNull Path destinationPath, @NonNull Charset charset) throws IOException {
        this(destinationPath, charset, false, true);
    }

    @Deprecated
    public AtomicFileWriter(@NonNull Path destinationPath, @NonNull Charset charset, boolean integrityOnFlush, boolean integrityOnClose) throws IOException {
        if (charset == null) {
            throw new IllegalArgumentException("charset is null");
        }
        this.destPath = destinationPath;
        Path dir = this.destPath.getParent();
        if (Files.exists(dir, new LinkOption[0]) && !Files.isDirectory(dir, new LinkOption[0])) {
            throw new IOException(String.valueOf(dir) + " exists and is neither a directory nor a symlink to a directory");
        }
        if (Files.isSymbolicLink(dir)) {
            LOGGER.log(Level.CONFIG, "{0} is a symlink to a directory", dir);
        } else {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        try {
            this.tmpPath = File.createTempFile(String.valueOf(this.destPath.getFileName()) + "-atomic", "tmp", dir.toFile()).toPath();
        }
        catch (IOException e) {
            throw new IOException("Failed to create a temporary file in " + String.valueOf(dir), e);
        }
        if (DISABLE_FORCED_FLUSH) {
            integrityOnFlush = false;
            integrityOnClose = false;
        }
        this.core = new FileChannelWriter(this.tmpPath, charset, integrityOnFlush, integrityOnClose, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        CLEANER.register(this, new CleanupChecker(this.core, this.tmpPath, this.destPath));
    }

    @Override
    public void write(int c) throws IOException {
        this.core.write(c);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.core.write(str, off, len);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.core.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.core.flush();
    }

    @Override
    public void close() throws IOException {
        this.core.close();
    }

    public void abort() throws IOException {
        try {
            this.close();
        }
        finally {
            Files.deleteIfExists(this.tmpPath);
        }
    }

    public void commit() throws IOException {
        this.close();
        try {
            AtomicFileWriter.move(this.tmpPath, this.destPath);
        }
        finally {
            try {
                Files.deleteIfExists(this.tmpPath);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e, () -> "Failed to delete temporary file " + String.valueOf(this.tmpPath) + " for destination file " + String.valueOf(this.destPath));
            }
        }
        if (!DISABLE_FORCED_FLUSH && REQUIRES_DIR_FSYNC) {
            try (FileChannel parentChannel = FileChannel.open(this.destPath.getParent(), new OpenOption[0]);){
                parentChannel.force(true);
            }
        }
    }

    private static void move(Path source, Path destination) throws IOException {
        if (atomicMoveSupported) {
            try {
                Files.move(source, destination, StandardCopyOption.ATOMIC_MOVE);
                return;
            }
            catch (AtomicMoveNotSupportedException e) {
                LOGGER.log(Level.WARNING, e, () -> "Atomic move " + String.valueOf(source) + " \u2192 " + String.valueOf(destination) + " not supported. Falling back to non-atomic move.");
                atomicMoveSupported = false;
            }
            catch (AccessDeniedException e) {
                LOGGER.log(Level.INFO, e, () -> "Move " + String.valueOf(source) + " \u2192 " + String.valueOf(destination) + " failed, perhaps due to a temporary file lock. Falling back to non-atomic move.");
            }
        }
        Files.move(source, destination, StandardCopyOption.REPLACE_EXISTING);
    }

    @Deprecated
    public File getTemporaryFile() {
        return this.tmpPath.toFile();
    }

    public Path getTemporaryPath() {
        return this.tmpPath;
    }

    static {
        if (DISABLE_FORCED_FLUSH) {
            LOGGER.log(Level.WARNING, "DISABLE_FORCED_FLUSH flag used, this could result in dataloss if failures happen in your storage subsystem.");
        }
    }

    private static final class CleanupChecker
    implements Runnable {
        private final FileChannelWriter core;
        private final Path tmpPath;
        private final Path destPath;

        CleanupChecker(FileChannelWriter core, Path tmpPath, Path destPath) {
            this.core = core;
            this.tmpPath = tmpPath;
            this.destPath = destPath;
        }

        @Override
        public void run() {
            if (this.core.isOpen()) {
                LOGGER.log(Level.WARNING, "AtomicFileWriter for " + String.valueOf(this.destPath) + " was not closed before being released");
                try {
                    this.core.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to close " + String.valueOf(this.tmpPath) + " for destination file " + String.valueOf(this.destPath), e);
                }
            }
            try {
                Files.deleteIfExists(this.tmpPath);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to delete temporary file " + String.valueOf(this.tmpPath) + " for destination file " + String.valueOf(this.destPath), e);
            }
        }
    }
}

