/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import hudson.Functions;
import hudson.MarkupText;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractMarkupText {
    AbstractMarkupText() {
    }

    public abstract String getText();

    public char charAt(int idx) {
        return this.getText().charAt(idx);
    }

    public final int length() {
        return this.getText().length();
    }

    public abstract MarkupText.SubText subText(int var1, int var2);

    public abstract void addMarkup(int var1, int var2, String var3, String var4);

    public void addHyperlink(int startPos, int endPos, String url) {
        this.addMarkup(startPos, endPos, "<a href='" + Functions.htmlAttributeEscape(url) + "'>", "</a>");
    }

    public void addHyperlinkLowKey(int startPos, int endPos, String url) {
        this.addMarkup(startPos, endPos, "<a class='lowkey' href='" + Functions.htmlAttributeEscape(url) + "'>", "</a>");
    }

    public void hide(int startPos, int endPos) {
        this.addMarkup(startPos, endPos, "<span style='display:none'>", "</span>");
    }

    public final void wrapBy(String startTag, String endTag) {
        this.addMarkup(0, this.length(), startTag, endTag);
    }

    public MarkupText.SubText findToken(Pattern pattern) {
        String text = this.getText();
        Matcher m = pattern.matcher(text);
        if (m.find()) {
            return this.createSubText(m);
        }
        return null;
    }

    public List<MarkupText.SubText> findTokens(Pattern pattern) {
        String text = this.getText();
        Matcher m = pattern.matcher(text);
        ArrayList<MarkupText.SubText> r = new ArrayList<MarkupText.SubText>();
        while (m.find()) {
            char ch;
            int idx = m.start();
            if (idx > 0 && (Character.isLetter(ch = text.charAt(idx - 1)) || Character.isDigit(ch)) || (idx = m.end()) < text.length() && (Character.isLetter(ch = text.charAt(idx)) || Character.isDigit(ch))) continue;
            r.add(this.createSubText(m));
        }
        return r;
    }

    protected abstract MarkupText.SubText createSubText(Matcher var1);
}

