/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.core;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.util.SafeContentHandler;
import org.dom4j.io.HTMLWriter;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class FileTag
extends TagSupport {
    private boolean doAppend = false;
    private String var;
    private String name;
    private boolean omitXmlDeclaration = false;
    private String outputMode = "xml";
    private boolean prettyPrint;
    private String encoding;

    @Override
    public void doTag(XMLOutput output) throws JellyTagException {
        block8: {
            try {
                if (this.name != null) {
                    String encoding = this.encoding != null ? this.encoding : "UTF-8";
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.name, this.doAppend), encoding);
                    this.writeBody(writer);
                    break block8;
                }
                if (this.var != null) {
                    StringWriter writer = new StringWriter();
                    this.writeBody(writer);
                    String result = writer.toString();
                    Object varValue = this.context.getVariable(this.var);
                    if (this.doAppend && varValue instanceof String) {
                        this.context.setVariable(this.var, String.valueOf(varValue) + result);
                    } else {
                        this.context.setVariable(this.var, result);
                    }
                    break block8;
                }
                throw new JellyTagException("This tag must have either the 'name' or the 'var' variables defined");
            }
            catch (FileNotFoundException e) {
                throw new JellyTagException(e);
            }
            catch (UnsupportedEncodingException e) {
                throw new JellyTagException(e);
            }
            catch (SAXException e) {
                throw new JellyTagException("could not write file", e);
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOmitXmlDeclaration(boolean omitXmlDeclaration) {
        this.omitXmlDeclaration = omitXmlDeclaration;
    }

    public void setOutputMode(String outputMode) {
        this.outputMode = outputMode;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setAppend(boolean doAppend) {
        this.doAppend = doAppend;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeBody(Writer writer) throws SAXException, JellyTagException {
        XMLOutput newOutput = this.createXMLOutput(writer);
        try {
            newOutput.setContentHandler(new SafeContentHandler(newOutput.getContentHandler()));
            newOutput.startDocument();
            this.invokeBody(newOutput);
            newOutput.endDocument();
        }
        finally {
            try {
                newOutput.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected XMLOutput createXMLOutput(Writer writer) {
        OutputFormat format = null;
        format = this.prettyPrint ? OutputFormat.createPrettyPrint() : new OutputFormat();
        if (this.encoding != null) {
            format.setEncoding(this.encoding);
        }
        if (this.omitXmlDeclaration) {
            format.setSuppressDeclaration(true);
        }
        boolean isHtml = this.outputMode != null && this.outputMode.equalsIgnoreCase("html");
        HTMLWriter xmlWriter = isHtml ? new HTMLWriter(writer, format) : new XMLWriter(writer, format);
        xmlWriter.setEscapeText(this.isEscapeText());
        XMLOutput answer = new XMLOutput((XMLWriter)xmlWriter){
            final /* synthetic */ XMLWriter val$xmlWriter;
            {
                this.val$xmlWriter = xMLWriter;
            }

            @Override
            public void close() throws IOException {
                this.val$xmlWriter.close();
            }
        };
        answer.setContentHandler((ContentHandler)xmlWriter);
        answer.setLexicalHandler((LexicalHandler)xmlWriter);
        return answer;
    }
}

