/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.xml;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXContentHandler;
import org.dom4j.io.SAXReader;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class ParseTagSupport
extends TagSupport {
    private static final Log log = LogFactory.getLog(ParseTagSupport.class);
    private String var;
    private String text;
    private SAXReader saxReader;

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public SAXReader getSAXReader() throws SAXException {
        if (this.saxReader == null) {
            this.saxReader = this.createSAXReader();
        }
        return this.saxReader;
    }

    public void setSAXReader(SAXReader saxReader) {
        this.saxReader = saxReader;
    }

    protected abstract SAXReader createSAXReader() throws SAXException;

    protected Document parseBody(XMLOutput output) throws JellyTagException {
        SAXContentHandler handler = new SAXContentHandler();
        XMLOutput newOutput = new XMLOutput((ContentHandler)handler);
        try {
            handler.startDocument();
            this.invokeBody(newOutput);
            handler.endDocument();
            return handler.getDocument();
        }
        catch (SAXException e) {
            throw new JellyTagException((Throwable)e);
        }
    }

    protected Document parseText(String text) throws JellyTagException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("About to parse: " + text));
        }
        try {
            return this.getSAXReader().read((Reader)new StringReader(text));
        }
        catch (DocumentException e) {
            throw new JellyTagException((Throwable)e);
        }
        catch (SAXException e) {
            throw new JellyTagException((Throwable)e);
        }
    }

    protected Document parse(Object source) throws JellyTagException {
        try {
            if (source instanceof String) {
                String uri = (String)source;
                source = this.context.getResource(uri);
            }
            if (source instanceof URL) {
                return this.getSAXReader().read((URL)source);
            }
            if (source instanceof File) {
                return this.getSAXReader().read((File)source);
            }
            if (source instanceof Reader) {
                return this.getSAXReader().read((Reader)source);
            }
            if (source instanceof InputStream) {
                return this.getSAXReader().read((InputStream)source);
            }
            throw new IllegalArgumentException("Invalid source argument. Must be a String, Reader, InputStream or URL. Was type; " + source.getClass().getName() + " with value: " + String.valueOf(source));
        }
        catch (DocumentException e) {
            throw new JellyTagException((Throwable)e);
        }
        catch (SAXException e) {
            throw new JellyTagException((Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new JellyTagException((Throwable)e);
        }
    }
}

